

#include "Sampling.h"



#define HASH_PREVIOUS_CELL_OFFSET   ((NumEntriesPerCell * CellCount) * (3 - BufferIndex))



#define HASH_DEBUG_OFFSET           (((NumEntriesPerCell * CellCount) * 9) + 3)

layout(std430) buffer   RadianceHashBuffer  { uint  radianceHashBuffer[];  };   
layout(std430) buffer   RadianceValueBuffer { uvec2 radianceValueBuffer[]; };   
uniform uint            NumEntriesPerCell;                                      
uniform uint            BufferIndex;                                            
uniform uint            CellCount;                                              
out flat vec3           vRadiance;                                              








void UnpackCell(in uvec3 packedCell, out vec3 position, out vec3 direction, out float cellSize)
{
    const vec2 unpackedCell = unpackHalf2x16(packedCell.y);
    position = vec3(unpackHalf2x16(packedCell.x), unpackedCell.x);
    direction = normalize(2.0f * unpackUnorm4x8(packedCell.z).xyz - 1.0f);
    cellSize = unpackedCell.y;  
}







vec4 UnpackRadianceValue(in uvec2 packedRadiance)
{
    return vec4(unpackHalf2x16(packedRadiance.x), unpackHalf2x16(packedRadiance.y));
}

_kernel


void DebugRadianceCells()
{
    vec3 b1, b2;
    float cellSize;
    uvec3 packedCell;
    vec3 position, direction;
    const uint entryIndex = radianceHashBuffer[HASH_PREVIOUS_CELL_OFFSET + gl_InstanceID];
    packedCell.x = radianceHashBuffer[HASH_DEBUG_OFFSET + 3 * entryIndex + 0];
    packedCell.y = radianceHashBuffer[HASH_DEBUG_OFFSET + 3 * entryIndex + 1];
    packedCell.z = radianceHashBuffer[HASH_DEBUG_OFFSET + 3 * entryIndex + 2];
    UnpackCell(packedCell, position, direction, cellSize);
    GetOrthoVectors(direction, b1, b2); 
    const vec3 cellPosition = position + 0.5f * cellSize * (0.5f * (Position.x * b1 + Position.y * b2) - direction);
    vRadiance = UnpackRadianceValue(radianceValueBuffer[entryIndex]).xyz;
    gl_Position = ViewProjection * vec4(cellPosition, 1.0f);
}
