

#ifndef RAYTRACE_H
#define RAYTRACE_H












bool RayIntersectBoxTest(in vec3 bmin, in vec3 bmax, in vec3 rayOrigin, in vec3 rayInverseDirection, out float rayIntersectionDistance)
{
    const float tx1 = (bmin.x - rayOrigin.x) * rayInverseDirection.x;
    const float tx2 = (bmax.x - rayOrigin.x) * rayInverseDirection.x;

    float tmin = min(tx1, tx2);
    float tmax = max(tx1, tx2);

    const float ty1 = (bmin.y - rayOrigin.y) * rayInverseDirection.y;
    const float ty2 = (bmax.y - rayOrigin.y) * rayInverseDirection.y;

    tmin = max(tmin, min(ty1, ty2));
    tmax = min(tmax, max(ty1, ty2));

    const float tz1 = (bmin.z - rayOrigin.z) * rayInverseDirection.z;
    const float tz2 = (bmax.z - rayOrigin.z) * rayInverseDirection.z;

    tmin = max(tmin, min(tz1, tz2));
    tmax = min(tmax, max(tz1, tz2));

    rayIntersectionDistance = tmin;

    return tmax >= max(0.0f, tmin);
}












bool RayIntersectPlaneTest(in vec3 planeCenter, in vec3 planeNormal, in vec3 rayOrigin, in vec3 rayDirection, out float rayIntersectionDistance)
{
    float denom = dot(planeNormal, rayDirection);
    if(abs(denom) < 0.0001f)
        return false;
    float t = dot(planeNormal, planeCenter - rayOrigin) / denom;
    if(t < 0)
        return false;
    rayIntersectionDistance = t;
    return true;
}












bool RayIntersectSphereTest(in vec3 sphereCenter, in float sphereRadius, in vec3 rayOrigin, in vec3 rayDirection, out float rayIntersectionDistance)
{
    float a = dot(rayDirection, rayDirection);
    vec3 s0_r0 = rayOrigin - sphereCenter;
    float b = 2.0f * dot(rayDirection, s0_r0);
    float c = dot(s0_r0, s0_r0) - (sphereRadius * sphereRadius);
    if(b * b - 4.0f * a * c < 0.0f)
        return false;
    rayIntersectionDistance = (-b - sqrt((b * b) - 4.0f * a * c)) / (2.0f * a);
    return true;
}













float RayIntersectTriangleTest(in vec3 origin, in vec3 direction, in vec3 v1, in vec3 v2, in vec3 v3, in float t_max, in float t_min)
{
    const vec3 e1 = v2 - v1;
    const vec3 e2 = v3 - v1;
    const vec3 s1 = cross(direction, e2);
    const float invd = 1.0f / dot(s1, e1);
    const vec3 d = origin - v1;
    const float b1 = dot(d, s1) * invd;
    const vec3 s2 = cross(d, e1);
    const float b2 = dot(direction, s2) * invd;
    const float temp = dot(e2, s2) * invd;

    if(b1 < 0.0f || b1 > 1.0f      ||
       b2 < 0.0f || b1 + b2 > 1.0f ||
       temp < t_min || temp > t_max)
        return t_max;

    return temp;
}

#endif 
