

#include "ShaderCore.h"

uniform sampler2D   ProbeBuffer;        
uniform usampler2D  ProbeMaskBuffer;    
out vec4            FragColor;          



#define PROBE_SIZE  8

_kernel


void DebugProbes()
{
    const uvec2 pos = uvec2(gl_FragCoord.xy);
    const uint probeMask = texelFetch(ProbeMaskBuffer, ivec2(pos / PROBE_SIZE), 0).x;
    if(probeMask == uint(-1))
    {
        FragColor = vec4(1.0f, 0.0f, 0.0f, 1.0f);
        return; 
    }
    const vec3 radiance = texelFetch(ProbeBuffer, ivec2(pos), 0).xyz;
    FragColor = vec4(radiance / FW_PI, 1.0f);   
}
