

#ifndef RAYTRACED_GI_H
#define RAYTRACED_GI_H



#define PROBE_SIZE      8



#define LONG_DISTANCE   1e9f







uint PackProbeMask(in uvec2 seed)
{
    return (seed.x << 16) | seed.y;
}







uvec2 UnpackProbeMask(in uint probeMask)
{
    return uvec2(probeMask >> 16, probeMask & 0xFFFFu);
}








vec2 GetVelocity(in vec2 uv, in float depth)
{
    const vec2 velocity = textureLod(VelocityBuffer, uv, 0.0f).xy;
    vec4 previousUv = Reprojection * vec4(2.0f * vec3(uv, depth) - 1.0f, 1.0f);
    previousUv.xy = 0.5f * previousUv.xy / previousUv.w + 0.5f;
    return uv - previousUv.xy + velocity;
}








vec3 GetCurrentWorldPosition(in vec2 uv, in float depth)
{
    const vec4 homogeneous = ViewProjectionInverse * vec4(2.0f * vec3(uv, depth) - 1.0f, 1.0f);
    return homogeneous.xyz / homogeneous.w; 
}








vec3 GetPreviousWorldPosition(in vec2 uv, in float depth)
{
    const vec4 homogeneous = PreviousViewProjectionInverse * vec4(2.0f * vec3(uv, depth) - 1.0f, 1.0f);
    return homogeneous.xyz / homogeneous.w; 
}







uint FindClosestProbe(in uvec2 pos)
{
    uvec2 dims = (BufferDimensions + PROBE_SIZE - 1) / PROBE_SIZE;
    pos = min(pos / PROBE_SIZE, dims - 1);
    for(uint i = 0; i < MipLevel; ++i)
    {
        const uint probe = texelFetch(ProbeMaskBuffer, ivec2(pos), int(i)).x;
        if(probe != uint(-1))
            return probe;   
        dims = max(dims >> 1, 1);
        pos = min(pos >> 1, dims - 1);
    }
    return uint(-1);
}








uint FindClosestProbe(in uvec2 pos, in ivec2 offset)
{
    uvec2 dims = (BufferDimensions + PROBE_SIZE - 1) / PROBE_SIZE;
    pos = min(pos / PROBE_SIZE, dims - 1);
    for(uint i = 0; i < MipLevel; ++i)
    {
        const ivec2 loc = ivec2(pos) + offset;
        if(any(lessThan(loc, ivec2(0))) || any(greaterThanEqual(loc, ivec2(dims))))
            break;  
        const uint probe = texelFetch(ProbeMaskBuffer, loc, int(i)).x;
        if(probe != uint(-1))
            return probe;   
        dims = max(dims >> 1, 1);
        pos = min(pos >> 1, dims - 1);
    }
    return uint(-1);
}

#endif 
