

#ifndef SHADER_SHARED_CODE_H
#define SHADER_SHARED_CODE_H

#ifdef FW_CPP







#define floatBitsToUint glm::floatBitsToUint



#define uintBitsToFloat glm::uintBitsToFloat



#define FW_STATIC       static inline



#define vec2            glm::vec2



#define vec3            glm::vec3



#define vec4            glm::vec4



#define uint            UInt32



#define uvec2           glm::uvec2



#define uvec3           glm::uvec3



#define uvec4           glm::uvec4



#define in



#define out



#define inout

namespace Framework
{
    namespace Rendering
    {

#else 

        
        
        #define FW_STATIC

#endif 

        
        
        

        
        
        #define FW_BIN_COUNT            8192u

        
        
        #define FW_SPLIT_COUNT          4u

        
        
        #define FW_ENVIRONMENT_MIPS     5u

        
        
        
        
        #define FW_TILE_SIZE            16u

        
        
        #define FW_SHADOW_ATLAS_SIZE    16u

        
        
        #define FW_BUFFER_CACHE_SIZE    16u

        
        
        #define FW_TEXTURE_CACHE_SIZE   20u

        
        
        #define FW_VOLUME_CACHE_SIZE    16u

        
        
        

        
        
        struct DrawCommand
        {
            uint    m_count;            
            uint    m_instanceCount;    
            uint    m_firstIndex;       
            uint    m_baseVertex;       
            uint    m_baseInstance;     
        };

        
        
        struct DispatchCommand
        {
            uint    m_numGroupsX;       
            uint    m_numGroupsY;       
            uint    m_numGroupsZ;       
        };

        
        
        struct HitData
        {
            vec4    m_data;             
        };

        
        
        struct LightData
        {
            vec4    m_position;         
            vec4    m_radiance;         
            vec4    m_direction;        
            vec4    m_lightData;        
        };

        
        
        struct MaterialData
        {
            vec4    m_materialData1;    
            vec4    m_materialData2;    
            vec4    m_materialData3;    
            vec4    m_materialData4;    
        };

        
        
        struct MeshData
        {
            vec4    m_matrixCol0;       
            vec4    m_matrixCol1;       
            vec4    m_matrixCol2;       
            vec4    m_meshData;         
        };

        
        
        struct PhotonData
        {
            vec4    m_position;         
            vec4    m_photonData;       
        };

        
        
        struct RayData
        {
            vec4    m_origin;           
            vec4    m_direction;        
        };

        
        
        struct AABB
        {
            vec4    m_minBounds;        
            vec4    m_maxBounds;        
        };

        
        
        struct AreaLight
        {
            vec4    m_v0;               
            vec4    m_v1;               
            vec4    m_v2;               
            vec4    m_v3;               
        };

        
        
        struct DynamicMesh
        {
            uint    m_firstIndex;       
            uint    m_baseVertex;       
            uint    m_count;            
            uint    m_unused;           
        };

        
        
        struct Shape
        {
            uint    m_firstIndex;       
            uint    m_baseVertex;       
        };

        
        
        struct Triangle
        {
            vec4    m_v0;               
            vec4    m_v1;               
            vec4    m_v2;               
        };

        
        
        struct Vertex
        {
            vec4    m_position;         
            vec4    m_normal;           
            vec4    m_texcoords;        
        };

        
        
        

        
        
        #define lightPoint          0

        
        
        #define lightSpot           1

        
        
        #define lightDirectional    2

        
        
        #define lightArea           3

        
        
        

        
        
        #define inPosition          0

        
        
        #define inNormal            1

        
        
        #define inTexcoords         2

        
        
        #define inTexcoords2        3

        
        
        #define inDrawId            4

#ifdef FW_CPP

    } 
} 





#undef floatBitsToUint
#undef uintBitsToFloat
#undef FW_STATIC

#undef vec2
#undef vec3
#undef vec4

#undef uint
#undef uvec2
#undef uvec3
#undef uvec4

#undef in
#undef out
#undef inout

#else 

#undef FW_STATIC

#endif 

#endif 
