

#include "Shadows.h"

noperspective sample in vec2    vTexcoords;                                         
uniform sampler2D               DepthBuffer;                                        
uniform sampler2DArray          ShadowMoments;                                      
layout(std430) buffer           LightDataBuffer { LightData lightDataBuffer[]; };   
uniform float                   ShadowBias;                                         
out vec4                        FragColor;                                          













float ComputeMSMHamburger(in vec4 moments, in float fragmentDepth, in float depthBias, in float momentBias)
{
    
    vec3 z;
    vec4 b = mix(moments, vec4(0.0f, 0.63f, 0.0f, 0.63f), momentBias);
    z[0] = fragmentDepth - depthBias;

    
    
    float L21D11 = -b[0] * b[1] + b[2];
    float D11 = -b[0] * b[0] + b[1];
    float InvD11 = 1.0f / D11;
    float L21 = L21D11 * InvD11;
    float SquaredDepthVariance = -b[1] * b[1] + b[3];
    float D22 = -L21D11 * L21 + SquaredDepthVariance;

    
    vec3 c = vec3(1.0f, z[0], z[0] * z[0]);

    
    c[1] -= b.x;
    c[2] -= b.y + L21 * c[1];

    
    c[1] *= InvD11;
    c[2] /= D22;

    
    c[1] -= L21 * c[2];
    c[0] -= dot(c.yz, b.xy);

    
    
    float InvC2 = 1.0f / c[2];
    float p = c[1] * InvC2;
    float q = c[0] * InvC2;
    float D = (p * p * 0.25f) - q;
    float r = sqrt(D);
    z[1] = -p * 0.5f - r;
    z[2] = -p * 0.5f + r;

    
    vec4 switchVal =
        z[2] < z[0] ? vec4(z[1], z[0], 1.0f, 1.0f) :
        z[1] < z[0] ? vec4(z[0], z[1], 0.0f, 1.0f) :
                      vec4(0.0f, 0.0f, 0.0f, 0.0f);
    float quotient = (switchVal[0] * z[2] - b[0] * (switchVal[0] + z[2]) + b[1]) / ((z[2] - switchVal[1]) * (z[0] - z[1]));

    float shadowIntensity = switchVal[2] + switchVal[3] * quotient;
    return 1.0f - clamp(shadowIntensity, 0.0f, 1.0f);
}

_kernel


void ClearShadows()
{
    FragColor = vec4(1.0f);
}

_kernel


void DrawShadows()
{
    float shadowTerm = 1.0f;
    LightData lightData = lightDataBuffer[0];
    const float depth = textureLod(DepthBuffer, vTexcoords, 0.0f).x;
#ifndef HAS_SHADOW_MOMENTS
    shadowTerm = ResolveShadowTerm(lightData, vTexcoords, depth, ShadowBias);
#else 
    vec4 shadowCoords;
    if(GetShadowMapCoordinates(lightData, vTexcoords, depth, shadowCoords))
        shadowTerm = ComputeMSMHamburger(textureLod(ShadowMoments, vec3(shadowCoords.xy, shadowCoords.w), 0.0f), shadowCoords.z, 0.0f, 3e-6f);
#endif 
    FragColor = vec4(shadowTerm);
}

#define g_sss_max_steps         16      
#define g_sss_ray_max_distance  0.05f   
#define g_sss_thickness         0.02f   
#define g_sss_step_length       (g_sss_ray_max_distance / g_sss_max_steps)

_kernel


void FilterShadows()
{
    const float depth = textureLod(DepthBuffer, vTexcoords, 0.0f).x;
    float shadowTerm = 1.0f;
    if(depth < 1.0f)
    {
        LightData lightData = lightDataBuffer[0];
        vec3 rayPosition = GetViewPosition(GetScreenPosition(vTexcoords), depth) + vec3(0.0f, 0.0f, 1e-2f);
        const vec3 rayDirection = normalize((View * vec4(lightData.m_position.xyz, 1.0f)).xyz - rayPosition);
        const vec3 rayStep = rayDirection * g_sss_step_length;
        for(uint i = 0; i < g_sss_max_steps; ++i)
        {
            rayPosition += rayStep;
            const vec4 homogeneous = Projection * vec4(rayPosition, 1.0f);
            const vec2 rayUv = 0.5f * homogeneous.xy / homogeneous.w + 0.5f;
            if(any(notEqual(rayUv, clamp(rayUv, 0.0f, 1.0f))))
                break;  
            const float rayDepth = GetLinearDepth(textureLod(DepthBuffer, rayUv, 0.0f).x);
            const float depthDelta = -(rayDepth + rayPosition.z);
            if(depthDelta > 0.0f && depthDelta < g_sss_thickness)
            {
                shadowTerm = 0.0f;
                break;  
            }
        }
    }
    FragColor = vec4(max(shadowTerm, 0.0f));
}
