

#ifndef SIGNED_DISTANCE_FUNCTIONS_H
#define SIGNED_DISTANCE_FUNCTIONS_H


















float sdSphere(in vec3 p, in float s)
{
    return length(p) - s;
}








float sdPlane(in vec3 p, in vec4 n)
{
    
    return dot(p, n.xyz) + n.w;
}








float sdBox(in vec3 p, in vec3 b)
{
    const vec3 q = abs(p) - b;
    return length(max(q, 0.0f)) + min(max(q.x, max(q.y, q.z)), 0.0f);
}









float sdRoundBox(in vec3 p, in vec3 b, in float r)
{
    const vec3 q = abs(p) - b + r;
    return length(max(q, 0.0f)) + min(max(q.x, max(q.y, q.z)), 0.0f) - r;
}








float sdCylinder(in vec3 p, in vec2 s)
{
    const vec2 d = abs(vec2(length(p.xz), p.y)) - s;

    return min(max(d.x, d.y), 0.0f) + length(max(d, 0.0f));
}








float sdOctahedron(in vec3 p, in float s)
{
    p = abs(p);
    const float m = p.x + p.y + p.z - s;
    vec3 q;
         if(3.0f * p.x < m) q = p.xyz;
    else if(3.0f * p.y < m) q = p.yzx;
    else if(3.0f * p.z < m) q = p.zxy;
    else return m * 0.57735027f;
    const float k = clamp(0.5f * (q.z - q.y + s), 0.0f, s);
    return length(vec3(q.x, q.y - s + k, q.z - k));
}








float sdTorus(in vec3 p, in vec2 t)
{
    const vec2 q = vec2(length(p.xz) - t.x, p.y);

    return length(q) - t.y;
}












float opUnion(in float d1, in float d2)
{
    return min(d1, d2);
}









float opSmoothUnion(in float d1, in float d2, in float k)
{
    const float h = clamp(0.5f + 0.5f * (d2 - d1) / k, 0.0f, 1.0f);
    return mix(d2, d1, h) - k * h * (1.0f - h);
}








float opSubtraction(in float d1, in float d2)
{
    return max(-d1, d2);
}









float opSmoothSubtraction(in float d1, in float d2, in float k)
{
    const float h = clamp(0.5f - 0.5f * (d2 + d1) / k, 0.0f, 1.0f);
    return mix(d2, -d1, h) + k * h * (1.0f - h);
}








float opIntersection(in float d1, in float d2)
{
    return max(d1, d2);
}









float opSmoothIntersection(in float d1, in float d2, in float k)
{
    const float h = clamp(0.5f - 0.5f * (d2 - d1) / k, 0.0f, 1.0f);
    return mix(d2, d1, h) + k * h * (1.0f - h);
}

#endif 
