

#include "ShaderCore.h"

noperspective sample in vec2    vTexcoords;         
uniform float                   Rayleigh;           
uniform float                   MieCoefficient;     
uniform float                   MieDirectional;     
uniform float                   SkyTurbidity;       
uniform vec3                    SunPosition;        
out vec4                        FragColor;          



const float n = 1.0003f;



const float N = 2.545e25;



const vec3 up = vec3(0.0f, 1.0f, 0.0f);



const vec3 lambda = vec3(680e-9, 550e-9, 450e-9);



const float rayleighZenithLength = 8.4e3;



const float mieZenithLength = 1.25e3;



const float sunAngularDiameterCos = 0.99995667694644844355f;



const float threeOverSixteenPi = 0.05968310365946075f;



const float oneOverFourPi = 0.07957747154594767f;




const vec3 totalRayleigh = vec3(5.804542996261093e-6, 1.3562911419845635e-5, 3.0265902468824876e-5);



const float v = 4.0f;



const vec3 K = vec3(0.686f, 0.678f, 0.666f);



const vec3 MieConst = vec3(1.8399918514433978e14, 2.7798023919660528e14, 4.0790479543861094e14);



const float cutoffAngle = 1.6110731556870734f;



const float steepness = 1.5f;







float RayleighPhase(in float cosTheta)
{
    return threeOverSixteenPi * (1.0f + pow(cosTheta, 2.0f));
}








float HgPhase(in float cosTheta, in float g)
{
    const float g2 = pow(g, 2.0f);
    const float inverse = 1.0f / pow(1.0f - 2.0f * g * cosTheta + g2, 1.5f);
    return oneOverFourPi * ((1.0f - g2) * inverse);
}







float SunIntensity(in float zenithAngleCos)
{
    return 1000.0f * max(0.0f, 1.0f - pow(FW_E, -((cutoffAngle - acos(clamp(zenithAngleCos, -1.0f, 1.0f))) / steepness)));
}







vec3 TotalMie(in float turbidity)
{
    const float c = (0.2f * turbidity) * 10e-18;
    return 0.434f * c * MieConst;
}















vec3 ShadeSky(in vec3 worldPosition)
{
    
    
    const float zenithAngle = acos(max(0.0f, dot(up, normalize(worldPosition - Eye))));
    const float inverse = 1.0f / (cos(zenithAngle) + 0.15f * pow(93.885f - ((zenithAngle * 180.0f) / FW_PI), -1.253f));
    const float sR = rayleighZenithLength * inverse;
    const float sM = mieZenithLength * inverse;

    
    const vec3 sunDirection = normalize(SunPosition);
    const float sunFade = 1.0f - clamp(1.0f - exp((SunPosition.y / 450000.0f)), 0.0f, 1.0f);
    const float rayleighCoefficient = Rayleigh - (1.0f * (1.0f - sunFade));
    const float sunEnergy = SunIntensity(dot(sunDirection, up));

    
    const vec3 betaR = totalRayleigh * rayleighCoefficient;
    
    const vec3 betaM = TotalMie(SkyTurbidity) * MieCoefficient;
    
    const vec3 Fex = exp(-(betaR * sR + betaM * sM));

    
    const float cosTheta = dot(normalize(worldPosition - Eye), sunDirection);
    const float rPhase = RayleighPhase(0.5f * cosTheta + 0.5f);
    const vec3 betaRTheta = betaR * rPhase;
    const float mPhase = HgPhase(cosTheta, MieDirectional);
    const vec3 betaMTheta = betaM * mPhase;
    vec3 Lin = pow(sunEnergy * ((betaRTheta + betaMTheta) / (betaR + betaM)) * (1.0f - Fex), vec3(1.5f));
    Lin *= mix(vec3(1.0f), pow(sunEnergy * ((betaRTheta + betaMTheta) / (betaR + betaM)) * Fex, vec3(1.0f / 2.0f)), clamp(pow(1.0f - dot(up, sunDirection), 5.0f), 0.0f, 1.0f));

    
    const vec3 direction = normalize(worldPosition - Eye);
    const float theta = acos(direction.y);              
    const float phi = atan(direction.z, direction.x);   
    const vec2 uv = vec2(phi, theta) / vec2(2.0f * FW_PI, FW_PI) + vec2(0.5f, 0.0f);
    vec3 L0 = vec3(0.1f) * Fex;

    
    const float sundisk = smoothstep(sunAngularDiameterCos, sunAngularDiameterCos + 0.00002f, cosTheta);
    L0 += (sunEnergy * 19000.0f * Fex) * sundisk;
    const vec3 texColor = (Lin + L0) * 0.04f + vec3(0.0f, 0.0003f, 0.00075f);

    return pow(texColor, vec3(1.0f / (1.2f + (1.2f * sunFade))));
}

_kernel


void DrawSky()
{
    const vec2 ndc = 2.0f * vTexcoords - 1.0f;
    vec4 worldPosition = ViewProjectionInverse * vec4(ndc, 0.0f, 1.0f);
    worldPosition.xyz /= worldPosition.w;   
    FragColor = vec4(ShadeSky(worldPosition.xyz), 1.0f);
}
