

#ifndef STOCHASTIC_DISSOLVE_SHADER_H
#define STOCHASTIC_DISSOLVE_SHADER_H

#include "Sampling.h"





void StochasticAlphaTesting(in bool useTemporalDither)
{
    float alphaThreshold = 0.5f;
    float alphaValue = abs(vMeshData.x) * Sample(floatBitsToUint(vMeshData.y), vTexcoords).w;
#ifdef USE_DISSOLVE_SHADER
    Surface surface;
    surface.m_normal = vNormal;
    surface.m_texcoords = vTexcoords;
    surface.m_objectPosition = vObjectPosition;
    surface.m_worldPosition = vWorldPosition;
    surface.m_shadingLayer = vec3(0.0f);
    DissolveShader(surface, alphaValue);    
#endif 
    if(vMeshData.x < 0.0f)
    {
        useTemporalDither = (useTemporalDither && HasJitter()); 
        alphaThreshold = fract(InterleavedGradientNoise(gl_FragCoord.xy)    
                       + (useTemporalDither ? InterleavedGradientNoise((Frame & 0xFFu) * (Rotate2D(2.0f * FW_PI * (Frame & 0xFFu) / 255.0f) * vec2(1.0f, 0.0f))) : 0.0f));
        alphaThreshold = clamp(alphaThreshold, 1e-6f, 1.0f);    
    }
    if(alphaValue < alphaThreshold)
        discard;    
}

#endif 
