

#include "ShaderCore.h"

layout(triangles)                            in;                                    
layout(triangle_strip, max_vertices = 3)     out;                                   
layout(std430) buffer   RWMinBoundsXBuffer   { float    rwMinBoundsXBuffer[];   };  
layout(std430) buffer   RWMinBoundsYBuffer   { float    rwMinBoundsYBuffer[];   };  
layout(std430) buffer   RWMinBoundsZBuffer   { float    rwMinBoundsZBuffer[];   };  
layout(std430) buffer   RWMaxBoundsXBuffer   { float    rwMaxBoundsXBuffer[];   };  
layout(std430) buffer   RWMaxBoundsYBuffer   { float    rwMaxBoundsYBuffer[];   };  
layout(std430) buffer   RWMaxBoundsZBuffer   { float    rwMaxBoundsZBuffer[];   };  
layout(std430) buffer   RWTriangleBuffer     { Triangle rwTriangleBuffer[];     };  
layout(std430) buffer   TriangleBlockBuffer  { uint     triangleBlockBuffer[];  };  
layout(std430) buffer   TriangleCountBuffer  { uint     triangleCountBuffer[];  };  
layout(std430) buffer   TriangleOffsetBuffer { uint     triangleOffsetBuffer[]; };  
uniform uint            ShapeCount;                                                 
flat in uint            vDrawId[];                                                  

_kernel


void CaptureTriangles()
{
    Triangle triangle;

    
    const uint triangleBoundsIndex = gl_PrimitiveIDIn + triangleBlockBuffer[vDrawId[0]];
    const uint triangleIndex = triangleBoundsIndex + triangleOffsetBuffer[0];
    if(triangleBoundsIndex >= triangleCountBuffer[0])
        return; 

    
    triangle.m_v0 = vec4(gl_in[0].gl_Position.xyz, uintBitsToFloat(ShapeCount + vDrawId[0]));
    triangle.m_v1 = vec4(gl_in[1].gl_Position.xyz, intBitsToFloat(gl_PrimitiveIDIn));
    triangle.m_v2 = vec4(gl_in[2].gl_Position.xyz, 0.0f);   

    
    const vec3 minBounds = min(triangle.m_v0.xyz, min(triangle.m_v1.xyz, triangle.m_v2.xyz)),
               maxBounds = max(triangle.m_v0.xyz, max(triangle.m_v1.xyz, triangle.m_v2.xyz));
    rwMinBoundsXBuffer[triangleBoundsIndex] = minBounds.x;
    rwMinBoundsYBuffer[triangleBoundsIndex] = minBounds.y;
    rwMinBoundsZBuffer[triangleBoundsIndex] = minBounds.z;
    rwMaxBoundsXBuffer[triangleBoundsIndex] = maxBounds.x;
    rwMaxBoundsYBuffer[triangleBoundsIndex] = maxBounds.y;
    rwMaxBoundsZBuffer[triangleBoundsIndex] = maxBounds.z;

    
    rwTriangleBuffer[triangleIndex] = triangle;
}
