

#ifndef VOXELIZE_H
#define VOXELIZE_H



#define AXISTEST_X01(a, b, fa, fb)                          \
    p0 = a * v0.y - b * v0.z;                               \
    p2 = a * v2.y - b * v2.z;                               \
    rad = fa * boundsHalfSize.y + fb * boundsHalfSize.z;    \
    if(min(p0, p2) > rad || max(p0, p2) < -rad)             \
        return false;

#define AXISTEST_X2(a, b, fa, fb)                           \
    p0 = a * v0.y - b * v0.z;                               \
    p1 = a * v1.y - b * v1.z;                               \
    rad = fa * boundsHalfSize.y + fb * boundsHalfSize.z;    \
    if(min(p0, p1) > rad || max(p0, p1) < -rad)             \
        return false;



#define AXISTEST_Y02(a, b, fa, fb)                          \
    p0 = -a * v0.x + b * v0.z;                              \
    p2 = -a * v2.x + b * v2.z;                              \
    rad = fa * boundsHalfSize.x + fb * boundsHalfSize.z;    \
    if(min(p0, p2) > rad || max(p0, p2) < -rad)             \
        return false;

#define AXISTEST_Y1(a, b, fa, fb)                           \
    p0 = -a * v0.x + b * v0.z;                              \
    p1 = -a * v1.x + b * v1.z;                              \
    rad = fa * boundsHalfSize.x + fb * boundsHalfSize.z;    \
    if(min(p0, p1) > rad || max(p0, p1) < -rad)             \
        return false;



#define AXISTEST_Z12(a, b, fa, fb)                          \
    p1 = a * v1.x - b * v1.y;                               \
    p2 = a * v2.x - b * v2.y;                               \
    rad = fa * boundsHalfSize.x + fb * boundsHalfSize.y;    \
    if(min(p1, p2) > rad || max(p1, p2) < -rad)             \
        return false;

#define AXISTEST_Z0(a, b, fa, fb)                           \
    p0 = a * v0.x - b * v0.y;                               \
    p1 = a * v1.x - b * v1.y;                               \
    rad = fa * boundsHalfSize.x + fb * boundsHalfSize.y;    \
    if(min(p0, p1) > rad || max(p0, p1) < -rad)             \
        return false;










bool PlaneIntersectBoxTest(in vec3 normal, in vec3 point, in vec3 boundsHalfSize)
{
    
    vec3 v0 = -boundsHalfSize - point,
         v1 =  boundsHalfSize - point;

    
    vec3 selector = vec3(greaterThan(normal, vec3(0.0f)));
    vec3 vmin = mix(v1, v0, selector),
         vmax = mix(v0, v1, selector);

    
    if(dot(normal, vmin) > 0.0f || dot(normal, vmax) < 0.0f)
        return false;

    return true;
}















bool TriangleIntersectBoxTest(in vec3 boundsCenter, in vec3 boundsHalfSize, in vec3 vertex0, in vec3 vertex1, in vec3 vertex2)
{
    vec3 fe;
    float p0, p1, p2, rad;

    
    vec3 v0 = vertex0 - boundsCenter,
         v1 = vertex1 - boundsCenter,
         v2 = vertex2 - boundsCenter;

    
    vec3 e0 = v1 - v0,
         e1 = v2 - v1,
         e2 = v0 - v2;

    
    vec3 axisMin = min(v0, min(v1, v2)),
         axisMax = max(v0, max(v1, v2));
    if(any(greaterThan(axisMin, boundsHalfSize)) || any(lessThan(axisMax, -boundsHalfSize)))
        return false;

    
    vec3 normal = cross(e0, e1);
    if(!PlaneIntersectBoxTest(normal, v0, boundsHalfSize))
        return false;

    
    fe = abs(e0);
    AXISTEST_X01(e0.z, e0.y, fe.z, fe.y);
    AXISTEST_Y02(e0.z, e0.x, fe.z, fe.x);
    AXISTEST_Z12(e0.y, e0.x, fe.y, fe.x);

    fe = abs(e1);
    AXISTEST_X01(e1.z, e1.y, fe.z, fe.y);
    AXISTEST_Y02(e1.z, e1.x, fe.z, fe.x);
    AXISTEST_Z0(e1.y, e1.x, fe.y, fe.x);

    fe = abs(e2);
    AXISTEST_X2(e2.z, e2.y, fe.z, fe.y);
    AXISTEST_Y1(e2.z, e2.x, fe.z, fe.x);
    AXISTEST_Z12(e2.y, e2.x, fe.y, fe.x);

    return true;
}

#endif 
