import os
import ssl
import shutil
import struct
import sys
import traceback

from urllib.request import urlopen
from os.path import getsize
from os.path import isfile

def unpack_int(string):
    """Read an n-byte big-endian integer from a byte string."""
    (ret,) = struct.unpack_from('>I', b'\x00' * (4 - len(string)) + string)
    return ret

def apply(patchpath, filepath, fake_header=False):
    patch_size = getsize(patchpath)
    patchfile = open(patchpath, 'rb')
    target = open(filepath, 'r+b')

    if patchfile.read(5) != b'PATCH':
        raise Exception('Invalid patch header.')

    # Read First Record
    r = patchfile.read(3)
    while patchfile.tell() not in [patch_size, patch_size - 3]:
        # Unpack 3-byte pointers.
        offset = unpack_int(r)
        if fake_header:
            offset -= 512
        # Read size of data chunk
        r = patchfile.read(2)
        size = unpack_int(r)

        if size == 0:  # RLE Record
            r = patchfile.read(2)
            rle_size = unpack_int(r)
            data = patchfile.read(1) * rle_size
        else:
            data = patchfile.read(size)

        if offset >= 0:
            # Write to file
            target.seek(offset)
            target.write(data)
        # Read Next Record
        r = patchfile.read(3)

    if patch_size - 3 == patchfile.tell():
        trim_size = unpack_int(patchfile.read(3))
        target.truncate(trim_size)

    # Cleanup
    target.close()
    patchfile.close()

try:
    print("downloading arkanoid.zip from archive.org -> the merged romset with all official supported arkanoid romsets")
    ctx = ssl.create_default_context()
    ctx.check_hostname = False
    ctx.verify_mode = ssl.CERT_NONE
    with urlopen("https://archive.org/download/mame-merged/mame-merged/arkanoid.zip",context=ctx) as response:
        body = response.read()
        with open("roms/arkanoid.zip", 'wb') as merged:
            merged.write(body)
            shutil.unpack_archive("roms/arkanoid.zip","arkanoid")

    print("creating arktrain.zip -> Arkanoid 102% Crack + Trainer by Pyrodex + Royal Connexion")
    shutil.copytree("arkanoid/arkatayt","arktrain")
    apply("patches/arktrain_ic81-v.ips","arktrain/ic81-v.3f")
    apply("patches/arktrain_ic82-w.ips","arktrain/ic82-w.5f")
    shutil.make_archive("roms/arktrain","zip","arktrain")
    shutil.rmtree("arktrain") 

    print("creating arktraid.zip -> Arkanoid 102% Crack + Trainer by Pyrodex + Royal Connexion / Demo Version by Abyss")
    shutil.copytree("arkanoid/arkatayt","arktraid")
    if isfile("arkanoid/a75__03.ic64"):
        shutil.copy("arkanoid/a75__03.ic64","arktraid/1-ic33.2c")
    else:
        shutil.copy("arkanoid/a75-03.ic64","arktraid/1-ic33.2c")
    if isfile("arkanoid/a75__04.ic63"):
        shutil.copy("arkanoid/a75__04.ic63","arktraid/2-ic34.3c")
    else:
        shutil.copy("arkanoid/a75-04.ic63","arktraid/2-ic34.3c")
    if isfile("arkanoid/a75__05.ic62"):
        shutil.copy("arkanoid/a75__05.ic62","arktraid/3-ic35.5c")
    else:
        shutil.copy("arkanoid/a75-05.ic62","arktraid/3-ic35.5c")
    apply("patches/arktraid_1-ic33.ips","arktraid/1-ic33.2c")
    apply("patches/arktraid_2-ic34.ips","arktraid/2-ic34.3c")
    apply("patches/arktraid_3-ic35.ips","arktraid/3-ic35.5c")
    apply("patches/arktraid_ic81-v.ips","arktraid/ic81-v.3f")
    apply("patches/arktraid_ic82-w.ips","arktraid/ic82-w.5f")
    shutil.make_archive("roms/arktraid","zip","arktraid")
    shutil.rmtree("arktraid") 

    shutil.rmtree("arkanoid")
    input("press enter to continue...")

except Exception as e:
    print(e)
    input("press enter to continue...")
