let music;
let duration;
let time = 0;
let animationFrameId = null;
let fullscreen = true;
let currentScene;

// listen to keys 
document.addEventListener('keydown', function(event) { // Copilot
  if (event.repeat) return; // ignore repeated keydown events 

  if (event.key === 'Escape') { // escape
    stopDemo();
  } else if (event.key === 'Enter') { // enter
    startDemo();
  }
}
);
var screenWidth;
var screenHeight;
var renderer;

const beatInSeconds = 60 / 120;
var sceneData = [
  {"startTime": beatInSeconds * 0, "duration": beatInSeconds * 30},
  {"startTime": beatInSeconds * 30, "duration": beatInSeconds * 58},
  {"startTime": beatInSeconds * 88, "duration": beatInSeconds * 64},
  {"startTime": beatInSeconds * 148, "duration": beatInSeconds * 60},
  {"startTime": beatInSeconds * 208, "duration": beatInSeconds * 36}
];

function initScene1(data) {
  data.scene = new THREE.Scene();
  data.bgScene = new THREE.Scene();
  data.textureScene = new THREE.Scene();
  data.scenePostProcess = new THREE.Scene();
  data.bgCamera = new THREE.PerspectiveCamera( 75, 16 / 9, 0.1, 1000 );
  data.bgCamera.position.z = 5;
  data.camera = new THREE.PerspectiveCamera( 75, 16 / 9, 0.1, 1000 );
  data.camera.position.z = 5;

  // Render the texture FBO
  data.textureRenderTarget = new THREE.WebGLRenderTarget(screenWidth, screenHeight);
  data.textureRenderTarget2 = new THREE.WebGLRenderTarget(screenWidth, screenHeight);

  // Apply the shader to the texture FBO
  data.shader = {
      uniforms: {
          texture: { value: data.textureRenderTarget2.texture },
          time: { value: 0 },
          speed: { value: 1 },
      },
      // Manually added vertex shader to get the fragment shader running
      vertexShader: `
          varying vec2 vUv;

          void main() {
              vUv = uv;
              gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
          }
      `,
      fragmentShader: `
          uniform sampler2D tex;
          uniform float time;
          uniform float speed;

          varying vec2 vUv;

          float random(float x) {
              return fract(sin(x) * 43758.5453123);
          }

          void main() {
              //gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
              vec2 uv = vUv;
              uv += vec2(
                  random(uv.y * 100.0 + time * speed),
                  random(uv.x * 100.0 + time * speed)
              ) * 0.005 - 0.0025;
              gl_FragColor = texture2D(tex, uv);
          }
      `
  };

  data.material = new THREE.ShaderMaterial({
      uniforms: THREE.UniformsUtils.clone(data.shader.uniforms),
      vertexShader: data.shader.vertexShader,
      fragmentShader: data.shader.fragmentShader
  });

  var planeGeometry = new THREE.PlaneGeometry(16, 9);
  data.planePostProcess = new THREE.Mesh(planeGeometry, data.material);
  data.scenePostProcess.add(data.planePostProcess);

  // Load the image texture
  let texture = new THREE.TextureLoader().load( 's1_bg.png' );

  var pictureTexture = texture;
  var pictureMaterial = new THREE.SpriteMaterial( { map: pictureTexture } );
  var picture = new THREE.Sprite( pictureMaterial );
  picture.scale.set( 16, 9, 1 );
  picture.position.set( 0, 0, -1 );
  data.textureScene.add( picture );

  data.tweens = [];
  
  var fontLoader = new THREE.FontLoader();
  fontLoader.load( 'helvetiker_regular.typeface.json', function ( font ) {
      var textGeometry = new THREE.TextGeometry( 'Power of Art', {
          font: font,
          size: 0.5,
          height: 0.1,
          curveSegments: 12,
          bevelEnabled: true,
          bevelThickness: 0.02,
          bevelSize: 0.02,
          bevelSegments: 5
      } );
      var textMaterial = new THREE.MeshBasicMaterial( { color: 0xffffff } );
      textMaterial.opacity = 1.0;
      var text = new THREE.Mesh( textGeometry, textMaterial );
      text.material.transparent = true;
      text.position.set( -1, -6, 0 );
      data.textureScene.add( text );

      //tween move text up to 0 in 5 seconds 
      var textTween = new TWEEN.Tween( text.position )
          .to( { y: 0 }, 5000 )
          .easing( TWEEN.Easing.Linear.None );

      //tween wait for 1 second and then fade out text in two seconds
      var waitTween = new TWEEN.Tween( textMaterial )
          .to( { opacity: 1 }, 1000 )
          .easing( TWEEN.Easing.Linear.None );
      var textFadeOutTween = new TWEEN.Tween( textMaterial )
          .to( { opacity: 0 }, 2000 )
          .easing( TWEEN.Easing.Linear.None );

      textTween.chain( waitTween );
      waitTween.chain( textFadeOutTween );
      textTween.start();

  } );

  // Set up the fade-in, display, and fade-out durations for the background
  var fadeInDuration = 2000; // 2 seconds
  var displayDuration = 3000; // 3 seconds
  var fadeOutDuration = 2000; // 2 seconds

  // Set the initial opacity of the background to 0
  pictureMaterial.opacity = 0;

  //tween wait 2 seconds  before fadeInTween
  var waitTween2 = new TWEEN.Tween( pictureMaterial )
      .to( { opacity: 0 }, 2000 )
      .easing( TWEEN.Easing.Linear.None );

  // Animate the opacity for the background fade-in
  var fadeInTween = new TWEEN.Tween( pictureMaterial )
      .to( { opacity: 1 }, fadeInDuration )
      .easing( TWEEN.Easing.Linear.None );

  // tween wait for 16 seconds
  var waitTween = new TWEEN.Tween( pictureMaterial )
      .to( { opacity: 1 }, displayDuration )
      .easing( TWEEN.Easing.Linear.None );

  // Animate the opacity for the background fade-out
  var fadeOutTween = new TWEEN.Tween( pictureMaterial )
      .to( { opacity: 0 }, fadeOutDuration )
      .easing( TWEEN.Easing.Linear.None );

  // Chain the tweens together for the background and start the animation
  waitTween2.chain( fadeInTween );
  fadeInTween.chain( waitTween );
  waitTween.chain( fadeOutTween );
  data.tweens.push( waitTween2 );

  var pictureMaterial = new THREE.SpriteMaterial( { map: data.textureRenderTarget.texture } );
  var picture = new THREE.Sprite( pictureMaterial );
  picture.scale.set( 16, 9, 1 );
  picture.position.set( 0, 0, -1 );
  data.scene.add( picture );
}

function animateScene2(data) {
  // Rotate cube x and y axis
  data.cube.rotation.x += 0.01;
  data.cube.rotation.y += 0.01;

  // Check if the current beat is a multiple of 4
  var currentBeat = Math.floor((time - data.startTime) / 60 * 120);
  if (currentBeat%4 == 0) {
      // Adjust the rotation speed
      rotationSpeed = Math.random() * 0.1 + 0.05;
  } else {
      // Adjust the rotation speed
      rotationSpeed = 0;
  }

  // Check if 12 beats have passed
  if (currentBeat > 11) {
      // Split the cube
      if (!data.split)  {
          // Add four smaller wireframe cubes
          var cubeGeometry1 = new THREE.BoxGeometry(0.5, 0.5, 0.5);
          var cubeGeometry2 = new THREE.BoxGeometry(0.5, 0.5, 0.5);
          var cubeGeometry3 = new THREE.BoxGeometry(0.5, 0.5, 0.5);
          var cubeGeometry4 = new THREE.BoxGeometry(0.5, 0.5, 0.5);
          var cubeMaterial1 = new THREE.MeshBasicMaterial({ color: 0xff0000, wireframe: true });
          var cubeMaterial2 = new THREE.MeshBasicMaterial({ color: 0x00ff00, wireframe: true });
          var cubeMaterial3 = new THREE.MeshBasicMaterial({ color: 0x0000ff, wireframe: true });
          var cubeMaterial4 = new THREE.MeshBasicMaterial({ color: 0xffff00, wireframe: true });
          var cube1 = new THREE.Mesh(cubeGeometry1, cubeMaterial1);
          var cube2 = new THREE.Mesh(cubeGeometry2, cubeMaterial2);
          var cube3 = new THREE.Mesh(cubeGeometry3, cubeMaterial3);
          var cube4 = new THREE.Mesh(cubeGeometry4, cubeMaterial4);
          cube1.position.set(0, 0, 0);
          cube2.position.set(0, 0, 0);
          cube3.position.set(0, 0, 0);
          cube4.position.set(0, 0, 0);
          data.cubeScene.add(cube1);
          data.cubeScene.add(cube2);
          data.cubeScene.add(cube3);
          data.cubeScene.add(cube4);

          // Animate the splitting effect and transition to scene 3
          var tween1 = new TWEEN.Tween(cube1.position).to({ x: -1, y: 1, z: 2 }, 500);
          var tween2 = new TWEEN.Tween(cube2.position).to({ x: 1, y: 1, z: 2 }, 500);
          var tween3 = new TWEEN.Tween(cube3.position).to({ x: -1, y: -1, z: 2 }, 500);
          var tween4 = new TWEEN.Tween(cube4.position).to({ x: 1, y: -1, z: 2 }, 500);
          tween1.chain(new TWEEN.Tween(cube1.position).to({ x: 0, y: 0, z: 0 }, 20000));
          tween2.chain(new TWEEN.Tween(cube2.position).to({ x: 0, y: 0, z: 0 }, 20000));
          tween3.chain(new TWEEN.Tween(cube3.position).to({ x: 0, y: 0, z: 0 }, 20000));
          tween4.chain(new TWEEN.Tween(cube4.position).to({ x: 0, y: 0, z: 0 }, 20000));
          tween1.easing(TWEEN.Easing.Quadratic.InOut);
          tween2.easing(TWEEN.Easing.Quadratic.InOut); 
          tween3.easing(TWEEN.Easing.Quadratic.InOut);
          tween4.easing(TWEEN.Easing.Quadratic.InOut);
          tween1.start();
          tween2.start();
          tween3.start();
          tween4.start();

          // Remove the main cube
          data.cubeScene.remove(data.cube);

          data.split = true;
      } 
  }

  // Rotate the cube

  if (data.split) {
      // Rotate the smaller cubes
      data.cubeScene.children.forEach(function(child) {
          if (child instanceof THREE.Mesh && child != data.cube) {
          child.rotation.x += rotationSpeed * 2;
          child.rotation.y += rotationSpeed * 2;
          }
      });

      // Reset the background image rotation
      // Note from Human: it was tested and AI could fix this bug but it requires significant 'splaining' from a human,
      // hence we interpret that AI does not want/know how to fix x and y axis
      data.plane.rotation.z = 0;
  }
}


function initScene2(data)  {
  data.scene = new THREE.Scene();
  data.bgScene = new THREE.Scene();
  data.textureScene = new THREE.Scene();
  data.scenePostProcess = new THREE.Scene();
  data.bgCamera = new THREE.PerspectiveCamera( 75, 16 / 9, 0.1, 1000 );
  data.bgCamera.position.z = 5;
  data.camera = new THREE.PerspectiveCamera( 75, 16 / 9, 0.1, 1000 );
  data.camera.position.z = 5;

  data.split = false;
  data.animateScene = animateScene2;

  // Render the texture FBO
  data.textureRenderTarget = new THREE.WebGLRenderTarget(screenWidth, screenHeight);
  data.textureRenderTarget2 = new THREE.WebGLRenderTarget(screenWidth, screenHeight);

  // Apply the shader to the texture FBO
  data.shader = {
      uniforms: {
          texture: { value: data.textureRenderTarget2.texture },
          time: { value: 0 },
          uGradingMid: { value: new THREE.Color(0.5, 0.5, 0.5) },
          uGradingLift: { value: new THREE.Color(0.2, 0.2, 0.2) },
          uGradingGamma: { value: new THREE.Color(1.0, 1.0, 1.0) }
      },
      // Manually added vertex shader to get the fragment shader running
      vertexShader: `
          varying vec2 vUv;

          void main() {
              vUv = uv;
              gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
          }
      `,
      fragmentShader: `
          uniform sampler2D tex;
          uniform float time;
          uniform vec3 uGradingMid;
          uniform vec3 uGradingLift;
          uniform vec3 uGradingGamma;
          varying vec2 vUv;

          float rand(vec2 co) {
          return fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453);
          }

          void main() {
          vec4 color = texture2D(tex, vUv);

          // Animate color grading over time
          float timeFactor = sin(time * 2.0);
          vec3 midTones = uGradingMid + vec3(timeFactor * 0.1, timeFactor * 0.05, timeFactor * -0.05);
          vec3 shadowTones = uGradingLift + vec3(timeFactor * 0.1, timeFactor * -0.05, timeFactor * 0.05);
          vec3 gamma = uGradingGamma + vec3(timeFactor * -0.1, timeFactor * 0.05, timeFactor * 0.05);

          // Apply color grading
          color.rgb = mix(midTones, color.rgb, gamma);
          color.rgb = mix(shadowTones, color.rgb, clamp(color.rgb, 0.0, 1.0));

          // Apply film grain
          vec3 noise = vec3(rand(vUv + time), rand(vUv + time * 2.0), rand(vUv + time * 3.0));
          noise = (noise - 0.5) * 0.05;
          color.rgb += noise;

          gl_FragColor = color;
          }
      `
  };

  data.material = new THREE.ShaderMaterial({
      uniforms: THREE.UniformsUtils.clone(data.shader.uniforms),
      vertexShader: data.shader.vertexShader,
      fragmentShader: data.shader.fragmentShader
  });

  var planeGeometry = new THREE.PlaneGeometry(16, 9);
  data.planePostProcess = new THREE.Mesh(planeGeometry, data.material);
  data.scenePostProcess.add(data.planePostProcess);

  data.rotationSpeed = 0;
  data.cubeScene = /*data.textureScene; //*/data.scenePostProcess; // FIXME

  // Add a plane to display the image
  var planeGeometry = new THREE.PlaneGeometry(1, 9/16);
  var planeMaterial = new THREE.MeshBasicMaterial({ map: new THREE.TextureLoader().load("s2_bg.png"), depthTest: false, depthWrite: false });
  data.plane = new THREE.Mesh(planeGeometry, planeMaterial);  data.plane.frustumCulled = false;
  data.plane.position.z = 4.64;
  data.cubeScene.add(data.plane);

  // Add a cube to rotate
  var cubeGeometry = new THREE.BoxGeometry();
  var cubeMaterial = new THREE.MeshBasicMaterial({ color: 0xffffff });
  data.cube = new THREE.Mesh(cubeGeometry, cubeMaterial);
  data.cube.position.z = 2;
  data.cubeScene.add(data.cube);

  data.cubeScene.add(data.camera);
}

// Animate the buildings to morph and change
function animateBuildings(data) {
  for (let i = 0; i < data.buildings.children.length; i++) {
  const building = data.buildings.children[i];
  const time = Date.now() * 0.001;

  // Morph the building
  const noise = Math.sin(time + building.position.x * 0.5) * Math.cos(time + building.position.y * 0.5);
  building.scale.y += noise * 0.02;
  building.rotation.x = noise * 0.1;
  building.rotation.z = noise * 0.1;

  // Change the color of the building
  building.material.color.setHSL(0.5 + noise * 0.2, 1, 0.5);

  }
}

// Move and rotate the camera along z-axis
function animateScene3(data) {
  // Move camera along z-axis
  data.z += 0.01;

  data.plane.position.z = data.z - 0.4;
  data.bgCamera.position.set(0, 0, data.z);

  // data.Rotate camera
  data.rotation += 0.001;
  data.bgCamera.rotation.z = data.rotation;

  if (time > data.startTime+data.duration-10) {
    // Animate the buildings to morph and change
    animateBuildings(data);
  }
}

function initScene3(data) {
  data.scene = new THREE.Scene();
  data.bgScene = new THREE.Scene();
  data.textureScene = new THREE.Scene();
  data.scenePostProcess = new THREE.Scene();
  data.bgCamera = new THREE.PerspectiveCamera( 75, 16 / 9, 0.1, 1000 );
  data.bgCamera.position.z = 5;
  data.camera = new THREE.PerspectiveCamera( 75, 16 / 9, 0.1, 1000 );
  data.camera.position.z = 5;

  // Render the texture FBO
  data.textureRenderTarget = new THREE.WebGLRenderTarget(screenWidth, screenHeight);
  data.textureRenderTarget2 = new THREE.WebGLRenderTarget(screenWidth, screenHeight);

  // Apply the shader to the texture FBO
  data.shader = {
      uniforms: {
          texture: { value: data.textureRenderTarget2.texture },
          time: { value: 0 },
          uIntensity: { value: 0.5 },
          uSpeed: { value: 1.0 },
          uDistortion: { value: 0.02 },
          uScanlineDensity: { value: 0.5 },
          uBloomColor: { value: new THREE.Color(1.0, 0.5, 0.0) },
          uBloomStrength: { value: 0.5 },
          uBloomRadius: { value: 0.01 }
      },
      // Manually added vertex shader to get the fragment shader running
      vertexShader: `
          varying vec2 vUv;

          void main() {
              vUv = uv;
              gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
          }
      `,
      fragmentShader: `
          uniform sampler2D tex;
          uniform float time;
          uniform float uIntensity;
          uniform float uSpeed;
          uniform float uDistortion;
          uniform float uScanlineDensity;
          uniform vec3 uBloomColor;
          uniform float uBloomStrength;
          uniform float uBloomRadius;
          varying vec2 vUv;

          float rand(vec2 co) {
          return fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453);
          }

          void main() {
          vec2 uv = vUv;
          float uTime = time;

          // Add time-based distortion
          uv += vec2(
          rand(vec2(uv.x + uTime * uSpeed, uv.y)) * uDistortion,
          rand(vec2(uv.x, uv.y + uTime * uSpeed)) * uDistortion
          );

          vec4 color = texture2D(tex, uv);

          // Add scanlines
          float scanlineOffset = floor(uv.y * uScanlineDensity) / uScanlineDensity;
          float scanlineIntensity = 1.0 - uIntensity;
          color.rgb *= mix(scanlineIntensity, 1.0, smoothstep(scanlineOffset - 0.002, scanlineOffset + 0.002, fract(uTime)));

          // Add bloom
          vec3 bloom = vec3(0.0);
          float bloomStrength = uBloomStrength * smoothstep(0.1, 1.0, uIntensity);
          vec2 bloomUv = vUv - vec2(0.5);
          for (float i = 0.0; i < 10.0; i += 1.0) {
          vec2 offset = vec2(i) * bloomUv / uBloomRadius;
          bloom += texture2D(tex, vUv + offset).rgb;
          }
          bloom *= bloomStrength;
          bloom *= uBloomColor;
          color.rgb += bloom;

          gl_FragColor = color;
          }
      `
  };

  data.material = new THREE.ShaderMaterial({
      uniforms: THREE.UniformsUtils.clone(data.shader.uniforms),
      vertexShader: data.shader.vertexShader,
      fragmentShader: data.shader.fragmentShader
  });

  data.z = 0;
  data.rotation = 0;

  var planeGeometry = new THREE.PlaneGeometry(160, 90);
  data.planePostProcess = new THREE.Mesh(planeGeometry, data.material);
  data.planePostProcess.position.x = 0;
  data.planePostProcess.position.y = 0;
  data.planePostProcess.position.z = -2;
  data.scenePostProcess.add(data.planePostProcess);
  
  data.buildings = new THREE.Group();
  data.animateScene = animateScene3;

  var planeGeometry = new THREE.PlaneGeometry(1, 16/9);
  var planeMaterial = new THREE.MeshBasicMaterial({ map: new THREE.TextureLoader().load("s3_bg.png"), depthTest: false, depthWrite:false });
  data.plane = new THREE.Mesh(planeGeometry, planeMaterial);
  data.plane.position.x = 0;
  data.plane.position.y = 0;
  data.plane.position.z = 0;
  data.bgScene.add(data.plane);
  
  data.scene3d = data.scenePostProcess;
  
  // Create the city skyline with wireframe boxes
  const buildingGeometry = new THREE.BoxGeometry(1, 1, 1);
  const buildingMaterial = new THREE.MeshBasicMaterial({ wireframe: true, color: 0xffffff });
  
  // Add buildings to the scene
  for (let i = -50; i <= 50; i += 2) {
    for (let j = -10; j <= 10; j += 2) {
      const building = new THREE.Mesh(buildingGeometry, buildingMaterial);
      building.position.set(i, j, 0);
      building.scale.y = Math.random() * 4 + 1;
      data.buildings.add(building);
    }
  }
  
  data.scene3d.add(data.buildings);  
}

function initScene4(data) {
  data.scene = new THREE.Scene();
  data.bgScene = new THREE.Scene();
  data.textureScene = new THREE.Scene();
  data.scenePostProcess = new THREE.Scene();
  data.bgCamera = new THREE.PerspectiveCamera( 75, 16 / 9, 0.1, 1000 );
  data.bgCamera.position.z = 5;
  data.camera = new THREE.PerspectiveCamera( 75, 16 / 9, 0.1, 1000 );
  data.camera.position.z = 5;

  // Render the texture FBO
  data.textureRenderTarget = new THREE.WebGLRenderTarget(screenWidth, screenHeight);
  data.textureRenderTarget2 = new THREE.WebGLRenderTarget(screenWidth, screenHeight);

  data.material = new THREE.MeshBasicMaterial({ map: data.textureRenderTarget2.texture, depthTest: false, depthWrite: false });
  data.sceneEffect = data.scenePostProcess;

  var planeGeometry = new THREE.PlaneGeometry(16, 9);
  var planeMaterial = new THREE.MeshBasicMaterial({ map: new THREE.TextureLoader().load("s4_bg.png"), depthTest: false });
  var plane = new THREE.Mesh(planeGeometry, planeMaterial);
  data.sceneEffect.add(plane);

          // Apply the shader to the texture FBO
          let shader2 = {
              uniforms: {
                  texture: { value: planeMaterial.texture },
                  time: { value: 0 },
              },
              // Manually added vertex shader to get the fragment shader running
              vertexShader: `
                  varying vec2 vUv;

                  void main() {
                      vUv = uv;
                      gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
                  }
              `,
              fragmentShader: `
                  // The camera flies through a landscape of swirling colors and shapes
                  precision highp float;
                  uniform float time;
                  #define PI 3.14159265359
                  varying vec2 vUv;

                  void main() {
                  vec2 position = (vUv.xy / vec2(1.0,1.0)) * 2.0 - 1.0;
                  position.x *= 1.0/1.0;

                  float dist = length(position);
                  float angle = atan(position.y, position.x);

                  float timeMod = mod(time, 20.0);
                  float swirlSize = 0.1 + 0.2 * (timeMod / 20.0);
                  float zoom = 2.0 * (1.0 - pow(1.0 - min(time, 15.0) / 15.0, 2.0));

                  float radius = dist + swirlSize * sin(angle * 20.0 + time * 3.0);
                  angle += time * 0.1;

                  vec3 color = vec3(
                    0.5 + 0.5 * sin(radius * 4.0 - time * 3.0),
                    0.5 + 0.5 * sin(radius * 8.0 - time * 2.0),
                    0.5 + 0.5 * sin(radius * 16.0 - time * 4.0)
                  );

                  vec3 landscape = vec3(
                    pow((1.0 - position.y) * 0.5, 2.0) * zoom,
                    pow((1.0 - position.y) * 0.5, 3.0) * zoom * 0.5,
                    pow((1.0 - position.y) * 0.5, 4.0) * zoom * 0.25
                  );

                  color += landscape;

                  // lens flare 
                  vec2 uv = vUv - vec2(0.5);

                  // Calculate angle and distance from center
                  angle = atan(uv.y, uv.x);
                  dist = length(uv);

                  // Create lens flare
                  float flare = pow(1.0 - dist, 2.0) * 0.8;
                  flare *= sin(angle * 12.0 + time * 8.0) * 0.5 + 0.5;
                  flare *= pow(sin(dist * 30.0 + time * 10.0), 2.0);
                  flare *= pow(sin(dist * 100.0 + time * 20.0), 2.0);

                  // Add lens flare to color
                  color += vec3(flare, flare, flare);

                  gl_FragColor = vec4(color, 0.4);
                  }
              `
          };

          data.material2 = new THREE.ShaderMaterial({
              uniforms: THREE.UniformsUtils.clone(shader2.uniforms),
              vertexShader: shader2.vertexShader,
              fragmentShader: shader2.fragmentShader
          });

          var planeGeometry = new THREE.PlaneGeometry(16, 9);
          data.plane = new THREE.Mesh(planeGeometry, data.material2);
          data.plane.material.transparent = true;
          data.sceneEffect.add(data.plane);

    const fontLoader = new THREE.FontLoader();
    fontLoader.load("helvetiker_regular.typeface.json", (font) => {
      const textObjects = [];
      const textMaterials = [
        new THREE.MeshBasicMaterial({ color: 0xff0000 }),
        new THREE.MeshBasicMaterial({ color: 0x00ff00 }),
        new THREE.MeshBasicMaterial({ color: 0x0000ff }),
        new THREE.MeshBasicMaterial({ color: 0xff00ff }),
        new THREE.MeshBasicMaterial({ color: 0xffff00 }),
      ];
      const textOptions = {
        font,
        size: 0.7,
        height: 0.1,
      };
      const textLines = [
        "Fairlight",
        "The Black Lotus",
        "Andromeda Software Development",
        "Orange",
        "Conspiracy",
        "RGBA",
        "TBL (The Beyonders)",
        "Plastic",
        "Farbrausch",
        "ASD (Alcatraz and Sanctuary Design)",
        "MFX (Madwizards and Farbrausch)",
        "Mercury",
        "Cocoon",
        "Haujobb",
        "TRSI (The Red Sector Inc.)",
        "Rebels",
      ];

      let currentIndex = 0;

      const renderTextLine = () => {
        if (currentIndex >= textLines.length) {
          currentIndex = 0;
        }

        const textGeometry = new THREE.TextGeometry(textLines[currentIndex], textOptions);
        const textMaterial = textMaterials[currentIndex % textMaterials.length];
        const textMesh = new THREE.Mesh(textGeometry, textMaterial);

        textMesh.position.x = -8;
        textMesh.position.y = 4 + currentIndex * -0.5;
        textMesh.position.z = -2;

        textObjects.push(textMesh);
        data.sceneEffect.add(textMesh);

        currentIndex++;

        setTimeout(() => {
          const objectToRemove = textObjects.shift();
          data.sceneEffect.remove(objectToRemove);
        }, 1000);
      };

      setInterval(renderTextLine, 1000);
    });
}
function initScene5(data) {
  data.scene = new THREE.Scene();
  data.bgScene = new THREE.Scene();
  data.textureScene = new THREE.Scene();
  data.scenePostProcess = new THREE.Scene();
  data.bgCamera = new THREE.PerspectiveCamera( 75, 16 / 9, 0.1, 1000 );
  data.bgCamera.position.z = 5;
  data.camera = new THREE.PerspectiveCamera( 75, 16 / 9, 0.1, 1000 );
  data.camera.position.z = 5;

  // Render the texture FBO
  data.textureRenderTarget = new THREE.WebGLRenderTarget(screenWidth, screenHeight);
  data.textureRenderTarget2 = new THREE.WebGLRenderTarget(screenWidth, screenHeight);

  // Apply the shader to the texture FBO
  data.shader = {
      uniforms: {
          texture: { value: data.textureRenderTarget2.texture },
          time: { value: 0 },
      },
      // Manually added vertex shader to get the fragment shader running
      vertexShader: `
          varying vec2 vUv;

          void main() {
              vUv = uv;
              gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
          }
      `,
      fragmentShader: `
          // "radial blur"
          uniform sampler2D tex;
          uniform float time;

          varying vec2 vUv;

          void main() {
          vec2 uv = vUv - 0.5;
          uv.x *= 1920.0 / 1080.0;

          // Center of the radial blur
          vec2 center = vec2(0.5, 0.5);

          // Calculate distance to center
          float dist = length(uv - center);

          // Amount of blur to apply based on distance
          float blur = pow(sin(dist * 10.0 + time * 2.0), 2.0);

          // Calculate blur offset
          vec2 offset = normalize(uv - center) * blur * 0.01;

          // Apply blur to original image
          vec4 color = texture2D(tex, vUv - offset);
          color += texture2D(tex, vUv + offset);
          color /= 2.0;

          gl_FragColor = color;
          }
      `
  };

  data.material = new THREE.ShaderMaterial({
    uniforms: THREE.UniformsUtils.clone(data.shader.uniforms),
    vertexShader: data.shader.vertexShader,
    fragmentShader: data.shader.fragmentShader
});

var planeGeometry = new THREE.PlaneGeometry(16, 9);
data.planePostProcess = new THREE.Mesh(planeGeometry, data.material);
data.scenePostProcess.add(data.planePostProcess);

// Add a plane to display the image
var planeGeometry = new THREE.PlaneGeometry(1, 9/16);
var planeMaterial = new THREE.MeshBasicMaterial({ map: new THREE.TextureLoader().load("s5_bg.png"), depthTest: false, depthWrite: false });
var plane = new THREE.Mesh(planeGeometry, planeMaterial);
plane.position.z = 4.67;
data.bgScene.add(plane);
            
// Create a human figure mesh
var torsoGeometry = new THREE.BoxGeometry(1, 2, 1);
var limbGeometry = new THREE.BoxGeometry(0.5, 1, 0.5);
var material = new THREE.MeshBasicMaterial({wireframe: true});

var torsoMesh = new THREE.Mesh(torsoGeometry, material);
var headMesh = new THREE.Mesh(limbGeometry, material);
var leftArmMesh = new THREE.Mesh(limbGeometry, material);
var rightArmMesh = new THREE.Mesh(limbGeometry, material);
var leftLegMesh = new THREE.Mesh(limbGeometry, material);
var rightLegMesh = new THREE.Mesh(limbGeometry, material);

// Position the body parts
headMesh.position.y = 2.5;
leftArmMesh.position.set(-1, 1.5, 0);
rightArmMesh.position.set(1, 1.5, 0);
leftLegMesh.position.set(-0.5, -1, 0);
rightLegMesh.position.set(0.5, -1, 0);

// Create a group to hold the mesh
data.mesh = new THREE.Group();
data.mesh.add(torsoMesh);
data.mesh.add(headMesh);
data.mesh.add(leftArmMesh);
data.mesh.add(rightArmMesh);
data.mesh.add(leftLegMesh);
data.mesh.add(rightLegMesh);

// Create a skeleton and attach the bones to it
var bones = [];
var torsoBone = new THREE.Bone();
bones.push(torsoBone);

var headBone = new THREE.Bone();
headBone.position.y = 2.5;
torsoBone.add(headBone);

var leftArmBone = new THREE.Bone();
leftArmBone.position.set(-1, 1.5, 0);
torsoBone.add(leftArmBone);

var rightArmBone = new THREE.Bone();
rightArmBone.position.set(1, 1.5, 0);
torsoBone.add(rightArmBone);

var leftLegBone = new THREE.Bone();
leftLegBone.position.set(-0.5, -1, 0);
torsoBone.add(leftLegBone);

var rightLegBone = new THREE.Bone();
rightLegBone.position.set(0.5, -1, 0);
torsoBone.add(rightLegBone);

var skeleton = new THREE.Skeleton(bones);

data.scene3d = data.scenePostProcess;

data.mesh.position.z = 4;

// Add the mesh to the scene
data.scene3d.add(data.mesh); 

  data.tweens = [];

  // Create a Tween.js animation to zoom in on the wireframe mesh
  var zoomIn = new TWEEN.Tween(data.mesh.position)
    .to({ z: 1 }, 1000)
    .easing(TWEEN.Easing.Quadratic.Out); 

  // Create a Tween.js animation to zoom out and reveal the whole mesh
  var zoomOut = new TWEEN.Tween(data.mesh.position)
    .to({ z: 1 }, 1000)
    .easing(TWEEN.Easing.Quadratic.In);

  // Chain the animations together
  zoomIn.chain(zoomOut);
  data.tweens.push(zoomIn); 

  // Fade out to black picture
  let blackTexture = new THREE.TextureLoader().load('black.png');
  var blackMaterial = new THREE.SpriteMaterial( { map: blackTexture } );
  blackMaterial.opacity = 0;
  var blackPicture = new THREE.Sprite( blackMaterial );
  blackPicture.scale.set( 16, 9, 1 );
  blackPicture.position.set( 0, 0, 0 );
  data.scenePostProcess.add( blackPicture );

  const fadeOut = 4000;
  let fadeOutTween = new TWEEN.Tween( blackMaterial )
    .to( {opacity: 0}, 8000 )
    .easing( TWEEN.Easing.Linear.None )
    .chain(
      new TWEEN.Tween( blackMaterial )
        .to( {opacity: 1}, fadeOut )
        .easing( TWEEN.Easing.Linear.None )
    );
  data.tweens.push(fadeOutTween);
}

function init() {
  // Set up the scene, camera, and renderer
  screenWidth = window.innerWidth;
  screenHeight = window.innerWidth * 9 / 16;

  renderer = new THREE.WebGLRenderer({canvas: document.getElementById("canvas"), antialias: true});
  renderer.setSize( screenWidth, screenHeight );
  renderer.autoClear = false;
  //document.body.appendChild( renderer.domElement );

  // Set up the resize function to adjust the camera and renderer size
  function onWindowResize() {
      renderer.setSize( window.innerWidth, window.innerWidth * 9 / 16 );
      
      if (currentScene) {
        currentScene.camera.aspect = 16 / 9;
        currentScene.camera.updateProjectionMatrix();
      }
  }

  // Add an event listener for window resizing
  window.addEventListener( 'resize', onWindowResize, false );

  initScene1(sceneData[0]);
  initScene2(sceneData[1]);
  initScene3(sceneData[2]);
  initScene4(sceneData[3]);
  initScene5(sceneData[4]);
}

var startTime;
function startDemo() {

  let canvas = document.getElementById('canvas');
  music = document.getElementById('music');
  duration = 125; // in seconds

  //unhide canvas 
  canvas.style.display = 'block';
  // hide button 
  document.getElementById('start').style.display = 'none';

  if (fullscreen) {
    // Go fullscreen
    if (canvas.requestFullscreen) {
      canvas.requestFullscreen();
    } else if (canvas.webkitRequestFullscreen) {
      canvas.webkitRequestFullscreen();
    } else if (canvas.msRequestFullscreen) {
      canvas.msRequestFullscreen();
    }
  }

  // setTimeout 5 seconds (this is for demo capturing)
  setTimeout(function() {
    //print canvas size 
    console.log('canvas size: ' + canvas.width + 'x' + canvas.height);

    init();

    // Start the music
    music.play();

    startTime = new Date().getTime() / 1000;

    // Start the animation loop
    animationFrameId = requestAnimationFrame(animate);
  }, 5000);

}

let title = "Binary Odyssey";

function animate(timestamp) { 
  // Update the time
  time = music.currentTime;

  // Stop the animation if the time is up
  if (time >= duration) {
    console.log("Demo is over.");
    stopDemo();
    return;
  }

  TWEEN.update(time * 1000.0);

  // Render the scene
  renderer.clear();

  // loop sceneData
  for (var i = 0; i < sceneData.length; i++) {
    currentScene = sceneData[i];

    if (time < currentScene.startTime || time >= currentScene.startTime + currentScene.duration) {
      continue;
    }

    if (currentScene.tweens && !currentScene.tweenStarted) {
      currentScene.tweenStarted = true;
      for (var j = 0; j < currentScene.tweens.length; j++) {
        currentScene.tweens[j].start();
      }
    }

    if (currentScene.animateScene) {
      currentScene.animateScene(currentScene);
    }

    if (currentScene.material && currentScene.material.uniforms && currentScene.material.uniforms.time) {
      currentScene.material.uniforms.time.value = time;
    }
    if (currentScene.material2 && currentScene.material2.uniforms && currentScene.material2.uniforms.time) {
      currentScene.material2.uniforms.time.value = time;
    }
  
    renderer.setRenderTarget(currentScene.textureRenderTarget);
    renderer.clear();
    renderer.render(currentScene.bgScene, currentScene.bgCamera);
    renderer.render(currentScene.textureScene, currentScene.camera);
    renderer.setRenderTarget(null);
  
    // Full disclosure: Human intervention here to prevent "Feedback loop formed between Framebuffer and active Texture." error (not visible by eye though but better to fix for future compatibility)
    renderer.setRenderTarget(currentScene.textureRenderTarget2);
    renderer.clear();
    renderer.render( currentScene.scene, currentScene.bgCamera );

    renderer.setRenderTarget(null);
    renderer.render( currentScene.scenePostProcess, currentScene.bgCamera );
  }

  // Continue the animation
  animationFrameId = requestAnimationFrame(animate);
}

function stopDemo() {
  console.log("Stopping demo...");

  // Stop the music
  music.pause();

  // Rewind the music
  music.currentTime = 0;

  if (fullscreen) { // Copilot
    // Exit fullscreen
    if (document.exitFullscreen) {
      document.exitFullscreen();
    } else if (document.webkitExitFullscreen) {
      document.webkitExitFullscreen();
    } else if (document.msExitFullscreen) {
      document.msExitFullscreen();
    }
  }
  // Stop the animation loop
  cancelAnimationFrame(animationFrameId);

  // hide canvas and show start button 
  document.getElementById('start').style.display = 'block';
  canvas.style.display = 'none';
}