unit recrocodiler2;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Winapi.ShellAPI,
  System.DateUtils, Vcl.Graphics, System.UITypes,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, inifiles, Vcl.StdCtrls, Vcl.ExtCtrls,
  Vcl.Imaging.pngimage, Vcl.FileCtrl, mmsystem, AdvCheckBox, Vcl.MPlayer, System.Math;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Button2: TButton;
    Label4: TLabel;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    RadioGroup3: TRadioGroup;
    RadioGroup4: TRadioGroup;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    RadioGroup5: TRadioGroup;
    GroupBox2: TGroupBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    Label5: TLabel;
    Label6: TLabel;
    ImageKrokodil: TImage;
    Image2: TImage;
    GroupBox3: TGroupBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    Label7: TLabel;
    FileListBox1: TFileListBox;
    Timer1: TTimer;
    AdvCheckBox1: TAdvCheckBox;
    MediaPlayer1: TMediaPlayer;
    ImageIntro: TImage;
    TimerIntro: TTimer;
    Label8: TLabel;
    Label9: TLabel;


    procedure FormCreate(Sender: TObject);
    procedure Show(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure checkfiles;
    procedure fade;
    procedure codec;
    procedure acodec;
    procedure resolution;
    procedure Button2Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure RadioGroup3Click(Sender: TObject);
    procedure AdvCheckBox1Change(Sender: TObject);
    procedure MediaPlayer1Notify(Sender: TObject);
    procedure TimerIntroTimer(Sender: TObject);
    procedure Label6Click(Sender: TObject);
    procedure Label6MouseEnter(Sender: TObject);
    procedure Label6MouseLeave(Sender: TObject);




  private
    { Private declarations }
  public
    { Public declarations }
  end;

var

  Form1: TForm1;
  ini: Tinifile;
  hfile, filesize: integer;
  resol: extended;
  path, unreal_path, ffmpeg_path, cmd1, capture_x264, capture_x265,
    capture_h264, capture_h265, capture_audio, transcode_x264, transcode_x265,
    transcode_h264, transcode_h265, audiorecode, audiocopy, stereo, parm,
    capture_path, iname, transcode_path, sname, fadeout, exec, cml, codecstr,
    audiostr, wid, hig, vfilter, capture_pad, capture_fade, ffmpeg: string;
  index, files, message, DateTimeStamp, intro1, intro2, MaxStars : integer;
  x264, x265: boolean;
  fs: TSearchRec;
  rStream: TResourceStream;
  Date_Time, tbegin: TDateTime;
  resolh: array [1 .. 12] of String = (
    '720',
    '900',
    '1350',
    '1440',
    '1800',
    '2160',
    '2700',
    '2880',
    '3600',
    '4320',
    '4800',
    '5400'
  );
  resolw: array [1 .. 12] of String = (
    '576',
    '720',
    '1080',
    '1152',
    '1440',
    '1728',
    '2160',
    '2304',
    '2880',
    '3456',
    '3840',
    '4320'
  );

  type
  TScanLine = array [0..1023] of RGBQUAD;
  PScanLine = ^TScanLine;

const
  IntroLineFadeoutDelay = 320;  // -      (  ) []
  IntroFadeoutFrames = 64;  // -         (  ) []
  IntroFadeinFrames = 64;  // -    (  ) []
  IntroStarNum = 50;  // -  []
  IntroDistThreshold = 60;  //    ,    []
  IntroLineSpeed = 3;  //    ( - ) []

  IntroLineFrames = 500;  // -    []

var
  IntroEnabled: Boolean = True;  // / 
  IntroFrame: Integer = 0;  //   (  ,  ,   )
  IntroBrightness: Integer = IntroFadeoutFrames;
  IntroKrokoBitmap: TBitmap;
  IntroLines: array of PScanLine;
  IntroKrokoLines: array of PScanLine;
  IntroSizeX, IntroSizeY: Integer;
  IntroStars: array [0..IntroStarNum-1] of record
    x, y, dirX, dirY, hue: Single;
  end;


implementation

{$R *.dfm}

function IsWow64: BOOL;
type
  TIsWow64Process = function(hProcess: THandle;
    var Wow64Process: BOOL): BOOL; stdcall;
var
  IsWow64Process: TIsWow64Process;
begin
  Result := False;
  @IsWow64Process := GetProcAddress(GetModuleHandle(kernel32),
    'IsWow64Process');
  if Assigned(@IsWow64Process) then
    IsWow64Process(GetCurrentProcess, Result);
end;


function ExeAndWait(ExeNameAndParams: string;
  ncmdShow: integer = SW_SHOWNORMAL): integer;
var
  StartupInfo: TStartupInfo;
  ProcessInformation: TProcessInformation;
  Res: Bool;
  lpExitCode: DWORD;
begin
  with StartupInfo do // you can play with this structure
  begin
    cb := SizeOf(TStartupInfo);
    lpReserved := nil;
    lpDesktop := nil;
    lpTitle := nil;
    dwFlags := STARTF_USESHOWWINDOW;
    wShowWindow := ncmdShow;
    cbReserved2 := 0;
    lpReserved2 := nil;
  end;
  Res := CreateProcess(nil, PChar(ExeNameAndParams), nil, nil, true,
    CREATE_DEFAULT_ERROR_MODE or NORMAL_PRIORITY_CLASS, nil, nil, StartupInfo,
    ProcessInformation);
  while true do
  begin
    GetExitCodeProcess(ProcessInformation.hProcess, lpExitCode);
    if lpExitCode <> STILL_ACTIVE then
      Break;
    Application.ProcessMessages;
  end;
  result := integer(lpExitCode);
end;

procedure TForm1.checkfiles;
begin

  FileListBox1.items.Clear;
  files := 0;
  if FindFirst(capture_path + '\*.mp4', faAnyFile - faDirectory - faVolumeID,
    fs) = 0 then
    repeat
      inc(files);
      FileListBox1.items.Add(fs.name);
    until FindNext(fs) <> 0;
  FindClose(fs);
  if files <> 0 then
    Button2.Enabled := true
  else
  begin
    Button2.Enabled := false;
  end;

end;

function GetDosOutput(const execstr: string; const CommandLine: string)
  : ansistring;
var
  SA: TSecurityAttributes;
  SI: TStartupInfo;
  PI: TProcessInformation;
  StdOutPipeRead, StdOutPipeWrite: THandle;
  WasOK: boolean;
  Buffer: array [0 .. 255] of AnsiChar;
  BytesRead: cardinal;
  WorkDir: String;
  Line: ansistring;
begin
  Application.ProcessMessages;
  with SA do
  begin
    nLength := SizeOf(SA);
    bInheritHandle := true;
    lpSecurityDescriptor := nil;
  end;
  CreatePiPe(StdOutPipeRead, StdOutPipeWrite, @SA, 0);
  try
    with SI do
    begin
      FillChar(SI, SizeOf(SI), 0);
      cb := SizeOf(SI);
      dwFlags := STARTF_USESHOWWINDOW or STARTF_USESTDHANDLES;
      wShowWindow := SW_HIDE;
      hStdInput := GetStdHandle(STD_INPUT_HANDLE);
      hStdOutput := StdOutPipeWrite;
      hStdError := StdOutPipeWrite;
    end;
    WorkDir := ExtractFilePath(execstr);
    WasOK := CreateProcess(nil, PChar(execstr + ' ' + CommandLine), nil, nil,
      true, 0, nil, PChar(WorkDir), SI, PI);
    CloseHandle(StdOutPipeWrite);
    if not WasOK then
      raise Exception.Create('Could not execute command line!')
    else
      try
        Line := '';
        repeat
          WasOK := ReadFile(StdOutPipeRead, Buffer, 255, BytesRead, nil);
          if BytesRead > 0 then
          begin
            Buffer[BytesRead] := AnsiChar(#0);
            Line := Line + Buffer;
          end;
        until not WasOK or (BytesRead = 0);
        WaitForSingleObject(PI.hProcess, INFINITE);
      finally
        CloseHandle(PI.hThread);
        CloseHandle(PI.hProcess);
      end;
  finally
    result := Line;
    CloseHandle(StdOutPipeRead);
  end;
end;

procedure TForm1.codec;
begin
  if RadioGroup4.ItemIndex = 3 then
    codecstr := transcode_h265;
  if RadioGroup4.ItemIndex = 2 then
    codecstr := transcode_h264;
  if RadioGroup4.ItemIndex = 0 then
    codecstr := transcode_x264;
  if RadioGroup4.ItemIndex = 1 then
    codecstr := transcode_x265;
end;

procedure TForm1.fade;
var
  sec: extended;
  sss: string;
begin
  if CheckBox3.Checked = false then
    fadeout := ''
  else
  begin
    exec := ffmpeg_path + '\ffprobe.exe';
    cml := '-v quiet -select_streams 0 -show_entries stream=duration -of default=noprint_wrappers=1:nokey=1 "'
      + iname + '"';
    sss := utf8toansi(GetDosOutput(exec, cml));
    Delete(sss, Length(sss), 1);
    Delete(sss, Length(sss), 1);
    formatsettings.decimalseparator := '.';
    sec := trunc(strtofloat(sss)) - 1;
    sss := floattostr(sec);
    fadeout := ',fade=type=out:duration=1:start_time=' + sss +
      '[v];[0:a]afade=type=out:duration=1:start_time=' + sss +
      '[a] -map [v] -map [a]';
  end;
end;

procedure TForm1.acodec;
begin

  if CheckBox3.Checked = true
  then
    audiostr := audiorecode
  else
    audiostr := audiocopy


end;

procedure TForm1.resolution;
begin
  if RadioGroup3.ItemIndex = 0 then
  begin
    wid := '1280';
    hig := '720';
  end;
  if RadioGroup3.ItemIndex = 1 then
  begin
    wid := '1920';
    hig := '1080';
  end;
  if RadioGroup3.ItemIndex = 2 then
  begin
    wid := '3840';
    hig := '2160';
  end;
  if RadioGroup3.ItemIndex = 3 then
  begin
    wid := '7680';
    hig := '4320';
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  i: integer;
label
  vixod;
begin
  if WaveOutGetNumDevs<>0 then MediaPlayer1.Stop;
  Timer1.Enabled := false;
  ini := Tinifile.Create(path + '\rekrokodiler.ini');
  ini.WriteInteger('RESOLUTION', 'capture', RadioGroup1.ItemIndex);
  ini.WriteInteger('RESOLUTION', 'transcode', RadioGroup3.ItemIndex);
  ini.WriteInteger('CODEC', 'capture', RadioGroup2.ItemIndex);
  ini.WriteInteger('CODEC', 'transcode', RadioGroup4.ItemIndex);
  ini.Writebool('TRANSCODE', 'pad', CheckBox4.Checked);
  ini.Writebool('TRANSCODE', 'fade', CheckBox3.Checked);
  ini.Writebool('CAPTURE', 'pad', CheckBox6.Checked);
  ini.Writebool('CAPTURE', 'fade', CheckBox5.Checked);
  ini.Free;

  ini := Tinifile.Create(unreal_path + '\Unreal.ini');
  ini.WriteString('VIDEO', 'Border', '3');
  ini.WriteString('VIDEO', 'video', 'double');
  ini.WriteString('VIDEO', 'driver', 'blt');
  ini.Writebool('MISC', 'TapeTraps', CheckBox1.Checked);
  ini.Writebool('MISC', 'TapeAutoStart', CheckBox2.Checked);

  if RadioGroup5.ItemIndex = 0 then
    stereo := 'ABC';
  if RadioGroup5.ItemIndex = 1 then
    stereo := 'ACB';
  if RadioGroup5.ItemIndex = 2 then
    stereo := 'BAC';
  if RadioGroup5.ItemIndex = 3 then
    stereo := 'mono';
  ini.WriteString('AY', 'Stereo', stereo);
  index := RadioGroup1.ItemIndex + 1;

  if CheckBox6.Checked = false then
    capture_pad := ''
  else
  begin
    resol := trunc(StrToInt(resolw[index]) / 9 * 16);
    capture_pad := ',pad=' + floattostr(resol) + ':' + resolw[index] +
      ':(ow-iw)/2:(oh-ih)/2'
  end;

  if CheckBox5.Checked = false then
    capture_fade := ' -af volume=2.500000'
  else
    capture_fade :=
      ',reverse,fade=t=in:st=0:d=1,reverse -af volume=2.500000,areverse,afade=t=in:st=0:d=1,areverse';

  if RadioGroup2.ItemIndex = 0 then
    parm := '-ss 00:00:00.500 -vf scale=' + resolh[index] + ':' + resolw[index]
      + capture_pad + capture_fade + ' ' + capture_x264 + ' ' + capture_audio;
  if RadioGroup2.ItemIndex = 1 then
    parm := '-ss 00:00:00.500 -vf scale=' + resolh[index] + ':' + resolw[index]
      + capture_pad + capture_fade + ' ' + capture_x265 + ' ' + capture_audio;
  if RadioGroup2.ItemIndex = 2 then
    parm := '-ss 00:00:00.500 -vf scale=' + resolh[index] + ':' + resolw[index]
      + capture_pad + capture_fade + ' ' + capture_h264 + ' ' + capture_audio;
  if RadioGroup2.ItemIndex = 3 then
    parm := '-ss 00:00:00.500 -vf scale=' + resolh[index] + ':' + resolw[index]
      + capture_pad + capture_fade + ' ' + capture_h265 + ' ' + capture_audio;
  ini.WriteString('VIDEO', 'ffmpeg.parm', parm);

  ini.WriteString('VIDEO', 'ffmpeg.vout', '..\capture_video\video_' +
    FormatDateTime('dd.mm.yyyy', Now) + '_' + FormatDateTime('hh-mm-ss', Now) +
    '_#.mp4');
  ini.Free;
  Button1.Enabled := false;

  Form1.Visible := false;

  setcurrentdir(unreal_path);
  Button1.Enabled := false;

  ExeAndWait(unreal_path + '\Unreal.exe', SW_SHOW);

  Form1.Visible := true;
   if WaveOutGetNumDevs<>0 then MediaPlayer1.Stop;
  //if AdvCheckBox1.Checked = true then  MediaPlayer1.Stop;
  //if AdvCheckBox1.Checked = false then MediaPlayer1.Play;
  checkfiles;
  if FileListBox1.Count = 0 then
  begin
  ///  message := MessageDlg('Files for transcoding is absent!!', mtError,
  ///    [mbOK], 0);
    goto vixod;
  end;

  message := MessageDlg('Transcode the captured video?', mtConfirmation,
    [mbYes, mbNO], 0);
  if message = mrYes then
  begin
    IntroEnabled := false;
    for i := 0 to FileListBox1.Count - 1 do
    begin
      iname := capture_path + '\' + FileListBox1.items[i];
      DateTimeStamp := FileAge(iname);
      Date_Time := FileDateToDateTime(DateTimeStamp);
      sname := transcode_path + '\' +
        ChangeFileExt(ExtractFileName(FileListBox1.items[i]), '') + '_' +
        FormatDateTime('dd.mm.yyyy', Date_Time) + '_' +
        FormatDateTime('hh-mm-ss', Date_Time);

      fade;
      codec;
      acodec;
      resolution;

      if CheckBox4.Checked = false then
        vfilter := '-filter_complex scale=-2:' + hig;
      if CheckBox4.Checked = true then
        vfilter := '-filter_complex scale=-2:' + hig + ',pad=' + wid + ':' + hig
          + ':(ow-iw)/2:(oh-ih)/2';
      cmd1 := 'file=''' + sname + '.log''';
      SetEnvironmentVariable('FFREPORT', PWideChar(cmd1));
      tbegin := Now;
      cmd1 := 'ffmpeg\'+ ffmpeg +' -i "' + iname + '" ' + vfilter + fadeout + ' ' +
        codecstr + ' ' + audiostr + ' "' + sname + '.mp4"';
      ExeAndWait(ExtractFilePath(Application.ExeName) + cmd1, SW_SHOW);
      cmd1 := IntToStr(SecondsBetween(Now, tbegin));
      RenameFile(sname + '.mp4', sname + '_Uptime_' + cmd1 + 'sec.mp4');
    end;
    PlaySound('fx', 0, SND_RESOURCE or SND_ASYNC);
  end;
  IntroEnabled := true;
  message := MessageDlg('Render is FINISHED!!!', mtInformation, [mbOK], 0);

vixod:
  IntroEnabled := true;
  Timer1.Enabled := true;
  Button1.Enabled := true;
  if AdvCheckBox1.Checked = true then
    if WaveOutGetNumDevs<>0 then MediaPlayer1.Stop;
  if AdvCheckBox1.Checked = false then
    if WaveOutGetNumDevs<>0 then MediaPlayer1.Play;
end;

procedure TForm1.Show(Sender: TObject);
begin

  RadioGroup3.Buttons[4].Visible := false;
  RadioGroup3.Buttons[5].Visible := false;
  RadioGroup3.Buttons[6].Visible := false;
  RadioGroup3.Buttons[7].Visible := false;
  RadioGroup3.Buttons[8].Visible := false;
  RadioGroup3.Buttons[9].Visible := false;
  RadioGroup3.Buttons[10].Visible := false;
  RadioGroup3.Buttons[11].Visible := false;
  if x264 = false and x265 = false then Label7.Visible := true
  else
    Label4.Visible := true;
  if x264 = false then
  begin
    RadioGroup2.Buttons[2].Enabled := false;
    RadioGroup4.Buttons[2].Enabled := false;
  end;
  if x265 = false then
  begin
    RadioGroup2.Buttons[3].Enabled := false;
    RadioGroup4.Buttons[3].Enabled := false;
  end;

  ini := Tinifile.Create(path + '\rekrokodiler.ini');

  RadioGroup1.ItemIndex := ini.ReadInteger('RESOLUTION', 'capture', 8);
  ini.WriteInteger('RESOLUTION', 'capture', RadioGroup1.ItemIndex);

  RadioGroup3.ItemIndex := ini.ReadInteger('RESOLUTION', 'transcode', 3);
  ini.WriteInteger('RESOLUTION', 'transcode', RadioGroup3.ItemIndex);

  RadioGroup2.ItemIndex := ini.ReadInteger('CODEC', 'capture', 0);
  ini.WriteInteger('CODEC', 'capture', RadioGroup2.ItemIndex);

  RadioGroup4.ItemIndex := ini.ReadInteger('CODEC', 'transcode', 1);
  ini.WriteInteger('CODEC', 'transcode', RadioGroup4.ItemIndex);

  capture_x264 := ini.ReadString('CODECS_CAPTURE', 'x264',
    '-c:v libx264 -coder 1 -profile high -b:v 85M -minrate 85M -maxrate 85M -movflags +faststart -flags +cgop -pix_fmt yuv420p -crf 15 -tune film -preset slow -sws_flags neighbor -r 50');
  ini.WriteString('CODECS_CAPTURE', 'x264', capture_x264);

  capture_x265 := ini.ReadString('CODECS_CAPTURE', 'x265',
    '-c:v libx265 -crf 15 -profile:v main10 -b:v 85M -minrate 85M -maxrate 85M -coder 1 -preset slow -pix_fmt yuv420p10le -bf 2 -tune fastdecode -movflags +faststart -flags +cgop -sws_flags neighbor -r 50');
  ini.WriteString('CODECS_CAPTURE', 'x265', capture_x265);

  capture_h264 := ini.ReadString('CODECS_CAPTURE', 'h264',
    '-c:v h264_nvenc -b:v 0 -crf 15 -profile main -g 25 -pix_fmt yuv420p -movflags +faststart -tune film -flags +cgop -sws_flags neighbor -r 50');
  ini.WriteString('CODECS_CAPTURE', 'h264', capture_h264);

  capture_h265 := ini.ReadString('CODECS_CAPTURE', 'h265',
    '-c:v hevc_nvenc -profile main10 -g 25 -pix_fmt yuv444p -preset llhp -init_qpB 2 -movflags +faststart -flags +cgop -sws_flags neighbor -r 50');
  ini.WriteString('CODECS_CAPTURE', 'h265', capture_h265);

  capture_audio := ini.ReadString('CODECS_CAPTURE', 'audio',
    '-c:a aac -b:a 384k -ar 48000');
  ini.WriteString('CODECS_CAPTURE', 'audio', capture_audio);

  transcode_x264 := ini.ReadString('CODECS_TRANSCODE', 'x264',
    '-c:v libx264 -coder 1 -profile:v high -b:v 85M -minrate 85M -maxrate 85M -movflags +faststart -flags +cgop -pix_fmt yuv420p -crf 15 -tune film -preset slow -sws_flags spline -r 50');
  ini.WriteString('CODECS_TRANSCODE', 'x264', transcode_x264);

  transcode_x265 := ini.ReadString('CODECS_TRANSCODE', 'x265',
    '-c:v libx265 -crf 15 -profile:v main10 -coder 1 -preset slow -pix_fmt yuv420p -b:v 0 -bf 2 -tune fastdecode -movflags +faststart -flags +cgop -sws_flags spline -r 50');
  ini.WriteString('CODECS_TRANSCODE', 'x265', transcode_x265);

  transcode_h264 := ini.ReadString('CODECS_TRANSCODE', 'h264',
    '-c:v h264_nvenc -b:v 0 -crf 15 -profile:v main -g 25 -pix_fmt yuv420p -movflags +faststart -tune film -flags +cgop -sws_flags spline -r 50');
  ini.WriteString('CODECS_TRANSCODE', 'h264', transcode_h264);

  transcode_h265 := ini.ReadString('CODECS_TRANSCODE', 'h265',
    '-c:v hevc_nvenc -profile:v main10 -g 25 -pix_fmt yuv444p -preset llhp -init_qpB 2 -movflags +faststart -flags +cgop -sws_flags spline -r 50');
  ini.WriteString('CODECS_TRANSCODE', 'h265', transcode_h265);

  audiorecode := ini.ReadString('CODECS_TRANSCODE', 'audio_fade',
    '-c:a aac -b:a 384k -ar 48000');
  ini.WriteString('CODECS_TRANSCODE', 'audio_fade', audiorecode);

  audiocopy := ini.ReadString('CODECS_TRANSCODE', 'audio_nofade',
    '-strict -2 -c:a copy');
  ini.WriteString('CODECS_TRANSCODE', 'audio_nofade', audiocopy);

  CheckBox5.Checked := ini.ReadBool('CAPTURE', 'fade', false);
  ini.Writebool('CAPTURE', 'fade', CheckBox5.Checked);

  CheckBox6.Checked := ini.ReadBool('CAPTURE', 'pad', false);
  ini.Writebool('CAPTURE', 'pad', CheckBox6.Checked);

  CheckBox3.Checked := ini.ReadBool('TRANSCODE', 'fade', true);
  ini.Writebool('TRANSCODE', 'fade', CheckBox3.Checked);

  CheckBox4.Checked := ini.ReadBool('TRANSCODE', 'pad', false);
  ini.Writebool('TRANSCODE', 'pad', CheckBox4.Checked);

  AdvCheckBox1.Checked := ini.ReadBool('GENERAL', 'music', false);
  ini.Writebool('GENERAL', 'music', AdvCheckBox1.Checked);

  ini.Free;
  if AdvCheckBox1.Checked = true then
    if WaveOutGetNumDevs<>0 then MediaPlayer1.Stop;
  if AdvCheckBox1.Checked = false then
    if WaveOutGetNumDevs<>0 then MediaPlayer1.Play;

  ini := Tinifile.Create(unreal_path + '\Unreal.ini');
  CheckBox1.Checked := ini.ReadBool('MISC', 'TapeTraps', false);
  CheckBox2.Checked := ini.ReadBool('MISC', 'TapeAutoStart', false);
  stereo := ini.ReadString('AY', 'Stereo', 'ABC');
  if stereo = 'ABC' then RadioGroup5.ItemIndex := 0;
  if stereo = 'ACB' then RadioGroup5.ItemIndex := 1;
  if stereo = 'BAC' then RadioGroup5.ItemIndex := 2;
  if stereo = 'mono' then RadioGroup5.ItemIndex := 3;
  ini.WriteString('VIDEO', 'ffmpeg.exec', '..\ffmpeg\'+ ffmpeg +'.exe');
  ini.Free;
  if (x264 = false) and (x265 = false) then
  begin
    if RadioGroup2.ItemIndex = 2 then RadioGroup2.ItemIndex := 0;
    if RadioGroup2.ItemIndex = 3 then RadioGroup2.ItemIndex := 1;
    if RadioGroup4.ItemIndex = 2 then RadioGroup4.ItemIndex := 0;
    if RadioGroup4.ItemIndex = 3 then RadioGroup4.ItemIndex := 1;
  end;

end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  checkfiles;
end;

procedure TForm1.FormCreate(Sender: TObject);

var
  p: TPngImage;
  number, number2: integer;
begin
  if IsWow64 then
  begin
  form1.Caption:=form1.Caption+' (64 bit)';
  ffmpeg:='ffmpeg64';
  end
  else
  begin
  form1.Caption:=form1.Caption+' (32 bit)';
  ffmpeg:='ffmpeg';
  end;



  number := 1 + Random(4);
  number2 := 1 + Random(2);
  p := TPngImage.Create;
  try
    p.LoadFromResourceName(hinstance, 'kba'+ IntToStr(number2));
    Image2.Picture.Assign(p);
    p.LoadFromResourceName(hinstance, 'kroko' + IntToStr(number));
    with ImageKrokodil.Canvas do StretchDraw(ClipRect, p);
    //ImageKrokodil.Picture.Assign(p)
  finally
    freeandnil(p);
  end;
  Timer1.Enabled := true;

  getdir(0, path);

  unreal_path := path + '\UNREAL';
  ffmpeg_path := path + '\ffmpeg';
  capture_path := path + '\capture_video';
  transcode_path := path + '\transcode_video';
  cmd1 := ffmpeg_path + '\'+ffmpeg+' -y -i "' + ffmpeg_path +
    '\cuda.jpg" -c:v h264_nvenc "' + ffmpeg_path + '\test.mp4"';
  ExeAndWait(cmd1, SW_HIDE);
  hfile := fileopen(ffmpeg_path + '\test.mp4', fmOpenread);
  filesize := getfilesize(hfile, nil);
  fileclose(hfile);
  if filesize <> 0 then x264 := true;

  cmd1 := ffmpeg_path + '\'+ffmpeg+' -y -i "' + ffmpeg_path +
    '\cuda.jpg" -c:v hevc_nvenc "' + ffmpeg_path + '\test.mp4"';
  ExeAndWait(cmd1, SW_HIDE);
  hfile := fileopen(ffmpeg_path + '\test.mp4', fmOpenread);
  filesize := getfilesize(hfile, nil);
  fileclose(hfile);
  if filesize <> 0 then x265 := true;
  deletefile(ffmpeg_path + '\test.mp4');
  rStream := TResourceStream.Create(hinstance, 'music', 'MP3');
  try
    rStream.SaveToFile(path + '\2023_MmcM-Cogitationem.mp3');
  finally
    rStream.Free
  end;

  timerintro.Enabled:=true;
  if WaveOutGetNumDevs<>0 then
  begin
    MediaPlayer1.Wait := false;
    MediaPlayer1.Notify := true;
    MediaPlayer1.TimeFormat := tfFrames;
    MediaPlayer1.FileName := path + '\2023_MmcM-Cogitationem.mp3';
    MediaPlayer1.Open;
    MediaPlayer1.EndPos := MediaPlayer1.Length;
    MediaPlayer1.Stop;
  end;



  Randomize;
  IntroSizeX := ImageIntro.ClientWidth;
  IntroSizeY := ImageIntro.ClientHeight;

  IntroKrokoBitmap := TBitmap.Create;
  with IntroKrokoBitmap do
  begin
    Width := IntroSizeX;
    Height := IntroSizeY;
    PixelFormat := pf32bit;
    Canvas.Draw(0, 0, ImageKrokodil.Picture.Graphic);
  end;
  SetLength(IntroKrokoLines, IntroSizeY);
  for var y := 0 to High(IntroKrokoLines) do
    IntroKrokoLines[y] := PScanLine(IntroKrokoBitmap.ScanLine[y]);

  with ImageIntro.Picture.Bitmap do
  begin
    Width := IntroSizeX;
    Height := IntroSizeY;
    PixelFormat := pf32bit;
    Canvas.Draw(0, 0, ImageKrokodil.Picture.Graphic);
  end;
  SetLength(IntroLines, IntroSizeY);
  for var y := 0 to High(IntroLines) do
    IntroLines[y] := PScanLine(ImageIntro.Picture.Bitmap.ScanLine[y]);

  ImageKrokodil.Free;
  IntroEnabled := true;


end;

procedure TForm1.Label6Click(Sender: TObject);
begin
   ShellExecute(0, 'open', PChar(Label6.Caption), nil, nil, SW_SHOWNORMAL);
end;

procedure TForm1.Label6MouseEnter(Sender: TObject);
begin
  Label6.Font.Color := clBlue;
end;

procedure TForm1.Label6MouseLeave(Sender: TObject);
begin
  Label6.Font.Color := clWindowText;
end;

procedure TForm1.TimerIntroTimer(Sender: TObject);
const IntroDistThresholdHalf = IntroDistThreshold / 2;
begin
  // Set corner color and brightness
  var corner := IntroKrokoLines[0]^[0];
  if IntroFrame > IntroLineFadeoutDelay + IntroSizeY then
  begin
    IntroBrightness := IntroFadeoutFrames - (IntroFrame - (IntroLineFadeoutDelay + IntroSizeY));
    if IntroBrightness < 0 then IntroBrightness := 0;
  end;
  with corner do
  begin
    rgbBlue := rgbBlue * IntroBrightness div IntroFadeoutFrames;
    rgbGreen := rgbGreen * IntroBrightness div IntroFadeoutFrames;
    rgbRed := rgbRed * IntroBrightness div IntroFadeoutFrames;
  end;

  // Intro is disabled?
  if (not IntroEnabled) or (IntroFrame < 0) then
  begin
    if IntroFrame > 0 then
      if IntroFrame > IntroLineFadeoutDelay then
      begin
        if IntroFrame < IntroLineFadeoutDelay + IntroSizeY then
          IntroFrame := IntroLineFadeoutDelay - IntroFrame - 1000
        else IntroFrame := - IntroFadeinFrames
      end
      else IntroFrame := 0;
    if IntroFrame < 0 then
    begin
      if IntroFrame > -1000 then
      begin
        // Appearance by changing brightness (fade in)
        for var y := 0 to IntroSizeY-1 do
          for var x := 0 to IntroSizeX-1 do
          begin
            var step := IntroFrame + IntroFadeinFrames;
            var col := IntroKrokoLines[y]^[x];
            with col do
            begin
              rgbBlue := corner.rgbBlue + (rgbBlue - corner.rgbBlue) * step div IntroFadeinFrames;
              rgbGreen := corner.rgbGreen + (rgbGreen - corner.rgbGreen) * step div IntroFadeinFrames;
              rgbRed := corner.rgbRed + (rgbRed - corner.rgbRed) * step div IntroFadeinFrames;
            end;
            IntroLines[y]^[x] := col;
          end;
      end
      else
      begin
        // Appearance by lines
        for var x := 0 to IntroSizeX-1 do
        begin
          var start := IntroFrame + 1000 + IntroSizeY;
          var col := IntroKrokoLines[start]^[x];
          for var y := start+1 to IntroSizeY-1 do
            IntroLines[y]^[x] := col;
        end;
      end;
      ImageIntro.Repaint;
      Inc(IntroFrame);
      if IntroFrame = -1000 then IntroFrame := 0;
    end;
    Exit;
  end;

  // Intro is enabled
  if IntroFrame > IntroLineFadeoutDelay then
  begin
    if IntroFrame <= IntroLineFadeoutDelay + IntroSizeY then
    begin
      // Fade out by lines
      for var x := 0 to IntroSizeX-1 do
      begin
        var start := IntroLineFadeoutDelay + IntroSizeY - IntroFrame;
        var col := IntroKrokoLines[start]^[x];
        for var y := start+1 to IntroSizeY-1 do
          IntroLines[y]^[x] := col;
      end;
    end


    else if IntroFrame > IntroLineFadeoutDelay + IntroSizeY + IntroLineFrames then
      IntroFrame := - IntroFadeinFrames





    else
    begin
      // Stars and lines
      //-- init
      if IntroFrame = IntroLineFadeoutDelay + IntroSizeY + 1 then
      begin
        for var i := Low(IntroStars) to High(IntroStars) do
          with IntroStars[i] do
          begin
            x := Random * (IntroSizeX-1);
            y := Random * (IntroSizeY-1);
            dirX := Random * IntroLineSpeed - IntroLineSpeed / 2;
            dirY := Random * IntroLineSpeed - IntroLineSpeed / 2;
            hue := Random * 2 * Pi;
          end;
      end;
      with ImageIntro.Canvas do
      begin
        //-- draw lines
        var corner2 := RGB(corner.rgbRed, corner.rgbGreen, corner.rgbBlue);
//        var RedRange := 255 - corner.rgbRed;
        var GreenRange := 255 - corner.rgbGreen;
        var BlueRange := 255 - corner.rgbBlue;
        Brush.Color := corner2;
        FillRect(ClipRect);
        intro1:= High(IntroStars);
        intro2:= (IntroFrame - (IntroLineFadeoutDelay + IntroSizeY)) div 4 ;

        MaxStars := Min(intro1, intro2);

        for var i := Low(IntroStars) to MaxStars do
          for var j := Low(IntroStars) to MaxStars do
          begin
            if i = j then Continue;
            var dist := Sqrt(Sqr(IntroStars[i].x - IntroStars[j].x) + Sqr(IntroStars[i].y - IntroStars[j].y));
            var col := corner2;
            with corner do
              if dist <= IntroDistThreshold then
                if dist <= IntroDistThresholdHalf then
                  col := RGB(corner.rgbRed,
                    corner.rgbGreen + Trunc((IntroDistThresholdHalf - dist) * GreenRange / IntroDistThresholdHalf),
                    255)
                else
                  col := RGB(corner.rgbRed,
                    corner.rgbGreen,
                    corner.rgbBlue + Trunc((IntroDistThreshold - dist) * BlueRange / IntroDistThresholdHalf));
            if col <> corner2 then
            begin
              Pen.Color := col;
              MoveTo(Trunc(IntroStars[i].x), Trunc(IntroStars[i].y));
              LineTo(Trunc(IntroStars[j].x), Trunc(IntroStars[j].y));
            end;
          end;
        //-- draw and move stars
        for var i := Low(IntroStars) to MaxStars do
          with IntroStars[i] do
          begin
            var col := RGB(
              Trunc(127.99 + 127.99 * cos(IntroFrame * 0.1 + hue)),
              Trunc(127.99 + 127.99 * cos(IntroFrame * 0.1 + hue + 2.094395)),
              Trunc(127.99 + 127.99 * cos(IntroFrame * 0.1 + hue + 4.18879)));
            Brush.Color := col;
            Pen.Color := col;
            Ellipse(Trunc(x)-1, Trunc(y)-1, Trunc(x)+2, Trunc(y)+2);
            x := x + dirX;
            if x < 0 then
            begin
              x := - x;
              dirX := - dirX;
            end
            else if x >= IntroSizeX then
            begin
              x := 2*(IntroSizeX-1) - x;
              dirX := - dirX;
            end;
            y := y + dirY;
            if y < 0 then
            begin
              y := - y;
              dirY := - dirY;
            end
            else if y >= IntroSizeY then
            begin
              y := 2*(IntroSizeY-1) - y;
              dirY := - dirY;
            end;
          end;
      end;
    end;
    ImageIntro.Repaint;
  end;
  Inc(IntroFrame);
end;


procedure TForm1.MediaPlayer1Notify(Sender: TObject);
begin
  if WaveOutGetNumDevs<>0 then
  begin
    if MediaPlayer1.NotifyValue = nvSuccessful then
      begin
        if MediaPlayer1.Position >= MediaPlayer1.EndPos then
          begin
            MediaPlayer1.EndPos := MediaPlayer1.Length;
            MediaPlayer1.Position := 0;
            MediaPlayer1.Play;
            MediaPlayer1.Notify := true;
          end;
      end;
  end;

end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin

  if RadioGroup1.ItemIndex > 8 then
  begin
    if RadioGroup2.ItemIndex = 0 then RadioGroup2.ItemIndex := 1;
    if RadioGroup2.ItemIndex = 2 then RadioGroup2.ItemIndex := 3;
  end;
end;

procedure TForm1.RadioGroup3Click(Sender: TObject);
begin
  if RadioGroup3.ItemIndex = 3 then
  begin
    if RadioGroup4.ItemIndex = 0 then RadioGroup4.ItemIndex := 1;
    if RadioGroup4.ItemIndex = 2 then RadioGroup4.ItemIndex := 3;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  i: integer;
begin
  if WaveOutGetNumDevs<>0 then MediaPlayer1.Stop;

  Timer1.Enabled := false;
  IntroEnabled := false;
  ini := Tinifile.Create(path + '\rekrokodiler.ini');
  ini.WriteInteger('RESOLUTION', 'transcode', RadioGroup3.ItemIndex);
  ini.WriteInteger('CODEC', 'transcode', RadioGroup4.ItemIndex);
  ini.Writebool('TRANSCODE', 'pad', CheckBox4.Checked);
  ini.Writebool('TRANSCODE', 'fade', CheckBox3.Checked);
  ini.Free;

  for i := 0 to FileListBox1.Count - 1 do
  begin
    iname := capture_path + '\' + FileListBox1.items[i];
    DateTimeStamp := FileAge(iname);
    Date_Time := FileDateToDateTime(DateTimeStamp);
    sname := transcode_path + '\' + ChangeFileExt
      (ExtractFileName(FileListBox1.items[i]), '') + '_' +
      FormatDateTime('dd.mm.yyyy', Date_Time) + '_' + FormatDateTime('hh-mm-ss',
      Date_Time);
    fade;
    codec;
    acodec;
    resolution;

    if CheckBox4.Checked = false then
      vfilter := '-filter_complex scale=-2:' + hig;
    if CheckBox4.Checked = true then
      vfilter := '-filter_complex scale=-2:' + hig + ',pad=' + wid + ':' + hig +
        ':(ow-iw)/2:(oh-ih)/2';
    cmd1 := 'file=''' + sname + '.log''';
    SetEnvironmentVariable('FFREPORT', PWideChar(cmd1));

    cmd1 := 'ffmpeg\'+ffmpeg+' -report -i "' + iname + '" ' + vfilter + fadeout +
      ' ' + codecstr + ' ' + audiostr + ' "' + sname + '.mp4"';
    tbegin := Now;
    ExeAndWait(ExtractFilePath(Application.ExeName) + cmd1, SW_SHOW);
    cmd1 := IntToStr(SecondsBetween(Now, tbegin));
    RenameFile(sname + '.mp4', sname + '_Uptime_' + cmd1 + 'sec.mp4');
  end;

  IntroEnabled := true;
  PlaySound('fx', 0, SND_RESOURCE or SND_ASYNC);

  message := MessageDlg('Render is FINISHED!!!', mtInformation, [mbOK], 0);
  Timer1.Enabled := true;
  if AdvCheckBox1.Checked = true then
    if WaveOutGetNumDevs<>0 then MediaPlayer1.Stop;
  if AdvCheckBox1.Checked = false then
    if WaveOutGetNumDevs<>0 then MediaPlayer1.Play;
end;

procedure TForm1.AdvCheckBox1Change(Sender: TObject);
begin
  ini := Tinifile.Create(path + '\rekrokodiler.ini');
  ini.Writebool('GENERAL', 'music', AdvCheckBox1.Checked);
  ini.Free;
  if AdvCheckBox1.Checked = true then
    if WaveOutGetNumDevs<>0 then MediaPlayer1.Stop;
  if AdvCheckBox1.Checked = false then
    if WaveOutGetNumDevs<>0 then MediaPlayer1.Play;
end;

end.
