/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.DoubleBoundedRangeModel;
import com.jsyn.util.NumericOutput;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DoubleBoundedRangeSlider
extends JSlider {
    private static final long serialVersionUID = -440390322602838998L;
    private int places;

    public DoubleBoundedRangeSlider(DoubleBoundedRangeModel doubleBoundedRangeModel) {
        this(doubleBoundedRangeModel, 5);
    }

    public DoubleBoundedRangeSlider(DoubleBoundedRangeModel doubleBoundedRangeModel, int n) {
        super(doubleBoundedRangeModel);
        this.places = n;
        this.setBorder(BorderFactory.createTitledBorder(this.generateTitleText()));
        doubleBoundedRangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DoubleBoundedRangeSlider.this.updateTitle();
            }
        });
    }

    protected void updateTitle() {
        TitledBorder titledBorder = (TitledBorder)this.getBorder();
        if (titledBorder != null) {
            titledBorder.setTitle(this.generateTitleText());
            this.repaint();
        }
    }

    String generateTitleText() {
        DoubleBoundedRangeModel doubleBoundedRangeModel = (DoubleBoundedRangeModel)this.getModel();
        double d = doubleBoundedRangeModel.getDoubleValue();
        String string = NumericOutput.doubleToString(d, 0, this.places);
        return doubleBoundedRangeModel.getName() + " = " + string;
    }

    public void makeStandardLabels(int n) {
        this.setMajorTickSpacing(n / 2);
        this.setLabelTable(this.createStandardLabels(n));
        this.setPaintTicks(true);
        this.setPaintLabels(true);
    }

    public double nextLabelValue(double d, double d2) {
        return d + d2;
    }

    public void makeLabels(double d, double d2, int n) {
        DoubleBoundedRangeModel doubleBoundedRangeModel = (DoubleBoundedRangeModel)this.getModel();
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        double d3 = d;
        while (d3 <= doubleBoundedRangeModel.getDoubleMaximum()) {
            int n2 = doubleBoundedRangeModel.doubleToSlider(d3);
            String string = NumericOutput.doubleToString(d3, 0, n);
            hashtable.put(new Integer(n2), new JLabel(string));
            d3 = this.nextLabelValue(d3, d2);
        }
        this.setLabelTable(hashtable);
        this.setPaintLabels(true);
    }
}

