/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitFilter;

public class ExponentialRamp
extends UnitFilter {
    public UnitInputPort time = new UnitInputPort("Time");
    public UnitVariablePort current;
    private double target;
    private double timeHeld = 0.0;
    private double scaler = 1.0;

    public ExponentialRamp() {
        this.addPort(this.time);
        this.input.setup(1.0E-4, 1.0, 1.0);
        this.current = new UnitVariablePort("Current", 1.0);
        this.addPort(this.current);
    }

    @Override
    public void generate(int n, int n2) {
        double[] dArray = this.output.getValues();
        double d = this.input.getValues()[0];
        double d2 = this.time.getValues()[0];
        double d3 = this.current.getValue();
        if (d2 != this.timeHeld) {
            this.scaler = this.convertTimeToExponentialScaler(d2, d3, d);
            this.timeHeld = d2;
        }
        if (d != this.target) {
            this.scaler = this.convertTimeToExponentialScaler(d2, d3, d);
            this.target = d;
        }
        if (d3 < this.target) {
            for (int i = n; i < n2; ++i) {
                if ((d3 *= this.scaler) > this.target) {
                    d3 = this.target;
                    this.scaler = 1.0;
                }
                dArray[i] = d3;
            }
        } else if (d3 > this.target) {
            for (int i = n; i < n2; ++i) {
                if ((d3 *= this.scaler) < this.target) {
                    d3 = this.target;
                    this.scaler = 1.0;
                }
                dArray[i] = d3;
            }
        } else if (d3 == this.target) {
            for (int i = n; i < n2; ++i) {
                dArray[i] = this.target;
            }
        }
        this.current.setValue(d3);
    }

    private double convertTimeToExponentialScaler(double d, double d2, double d3) {
        double d4 = d2 * d3;
        if (d4 <= 1.0E-7) {
            throw new IllegalArgumentException("Exponential ramp crosses zero or gets too close to zero.");
        }
        double d5 = d * (double)this.getFrameRate();
        return Math.pow(d3 / d2, 1.0 / d5);
    }
}

