/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.FilterBiquad;

public abstract class FilterBiquadCommon
extends FilterBiquad {
    public UnitInputPort Q = new UnitInputPort("Q");
    protected static final double MINIMUM_Q = 1.0E-5;
    private double previousQ;
    protected double alpha;

    public FilterBiquadCommon() {
        this.addPort(this.Q);
        this.Q.setup(0.1, 1.0, 10.0);
    }

    public abstract void updateCoefficients();

    public void computeBiquadCommon(double d, double d2) {
        if (d >= 0.499) {
            d = 0.499;
        }
        this.omega = Math.PI * 2 * d;
        this.cos_omega = Math.cos(this.omega);
        this.sin_omega = Math.sin(this.omega);
        this.alpha = this.sin_omega / (2.0 * d2);
    }

    @Override
    public void recalculate() {
        double d = this.frequency.getValues()[0];
        double d2 = this.Q.getValues()[0];
        if (d < 1.0E-5) {
            d = 1.0E-5;
        }
        if (d2 < 1.0E-5) {
            d2 = 1.0E-5;
        }
        if (this.isRecalculationNeeded(d, d2)) {
            this.previousFrequency = d;
            this.previousQ = d2;
            double d3 = d * this.getFramePeriod();
            this.computeBiquadCommon(d3, d2);
            this.updateCoefficients();
        }
    }

    protected boolean isRecalculationNeeded(double d, double d2) {
        return d != this.previousFrequency || d2 != this.previousQ;
    }
}

