"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.printQRCode = printQRCode;
exports.printUsage = printUsage;
exports.printItem = exports.getTerminalColumns = exports.printHelp = exports.BLT = void 0;
var _chalk = _interopRequireDefault(require("chalk"));
var _qrcodeTerminal = _interopRequireDefault(require("qrcode-terminal"));
var _wrapAnsi = _interopRequireDefault(require("wrap-ansi"));
var Log = _interopRequireWildcard(require("../../log"));
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
        return obj;
    } else {
        var newObj = {};
        if (obj != null) {
            for(var key in obj){
                if (Object.prototype.hasOwnProperty.call(obj, key)) {
                    var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {};
                    if (desc.get || desc.set) {
                        Object.defineProperty(newObj, key, desc);
                    } else {
                        newObj[key] = obj[key];
                    }
                }
            }
        }
        newObj.default = obj;
        return newObj;
    }
}
const BLT = "\u203A";
exports.BLT = BLT;
const printHelp = ()=>{
    logCommandsTable([
        {
            key: "?",
            msg: "show all commands"
        }
    ]);
};
exports.printHelp = printHelp;
function printQRCode(url) {
    _qrcodeTerminal.default.generate(url, {
        small: true
    }, (code)=>Log.log(code)
    );
}
const getTerminalColumns = ()=>process.stdout.columns || 80
;
exports.getTerminalColumns = getTerminalColumns;
const printItem = (text)=>`${BLT} ` + (0, _wrapAnsi).default(text, getTerminalColumns()).trimStart()
;
exports.printItem = printItem;
function printUsage(options, { verbose  }) {
    const isMac = process.platform === "darwin";
    const { platforms =[
        "ios",
        "android",
        "web"
    ]  } = options;
    const isAndroidDisabled = !platforms.includes("android");
    const isIosDisabled = !platforms.includes("ios");
    const isWebDisable = !platforms.includes("web");
    if (verbose) {
        logCommandsTable([
            {},
            {
                key: "a",
                msg: "open Android",
                disabled: isAndroidDisabled
            },
            {
                key: "shift+a",
                msg: "select a device or emulator",
                disabled: isAndroidDisabled
            },
            isMac && {
                key: "i",
                msg: "open iOS simulator",
                disabled: isIosDisabled
            },
            isMac && {
                key: "shift+i",
                msg: "select a simulator",
                disabled: isIosDisabled
            },
            {
                key: "w",
                msg: "open web",
                disabled: isWebDisable
            },
            {},
            {
                key: "r",
                msg: "reload app"
            },
            !!options.isWebSocketsEnabled && {
                key: "j",
                msg: "open debugger"
            },
            !!options.isWebSocketsEnabled && {
                key: "m",
                msg: "toggle menu"
            },
            !!options.isWebSocketsEnabled && {
                key: "shift+m",
                msg: "more tools"
            },
            {
                key: "o",
                msg: "open project code in your editor"
            },
            {
                key: "c",
                msg: "show project QR"
            },
            {}, 
        ]);
    } else {
        logCommandsTable([
            {},
            {
                key: "a",
                msg: "open Android",
                disabled: isAndroidDisabled
            },
            isMac && {
                key: "i",
                msg: "open iOS simulator",
                disabled: isIosDisabled
            },
            {
                key: "w",
                msg: "open web",
                disabled: isWebDisable
            },
            {},
            {
                key: "j",
                msg: "open debugger"
            },
            {
                key: "r",
                msg: "reload app"
            },
            !!options.isWebSocketsEnabled && {
                key: "m",
                msg: "toggle menu"
            },
            {}, 
        ]);
    }
}
function logCommandsTable(ui) {
    Log.log(ui.filter(Boolean)// @ts-ignore: filter doesn't work
    .map(({ key , msg , status , disabled  })=>{
        if (!key) return "";
        let view = `${BLT} `;
        if (key.length === 1) view += "Press ";
        view += _chalk.default`{bold ${key}} {dim │} `;
        view += msg;
        if (status) {
            view += ` ${_chalk.default.dim(`(${_chalk.default.italic(status)})`)}`;
        }
        if (disabled) {
            view = _chalk.default.dim(view);
        }
        return view;
    }).join("\n"));
}

//# sourceMappingURL=commandsTable.js.map