"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.instantiateMetroAsync = instantiateMetroAsync;
exports.isWatchEnabled = isWatchEnabled;
var _config = require("@expo/config");
var _chalk = _interopRequireDefault(require("chalk"));
var _metroCore = require("metro-core");
var _log = require("../../../log");
var _getMetroProperties = require("../../../utils/analytics/getMetroProperties");
var _metroDebuggerMiddleware = require("../../../utils/analytics/metroDebuggerMiddleware");
var _rudderstackClient = require("../../../utils/analytics/rudderstackClient");
var _env = require("../../../utils/env");
var _createDevServerMiddleware = require("../middleware/createDevServerMiddleware");
var _platformBundlers = require("../platformBundlers");
var _metroTerminalReporter = require("./MetroTerminalReporter");
var _resolveFromProject = require("./resolveFromProject");
var _withMetroMultiPlatform = require("./withMetroMultiPlatform");
function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function instantiateMetroAsync(projectRoot, options) {
    let reportEvent;
    const Metro = (0, _resolveFromProject).importMetroFromProject(projectRoot);
    const ExpoMetroConfig = (0, _resolveFromProject).importExpoMetroConfigFromProject(projectRoot);
    const terminal = new _metroCore.Terminal(process.stdout);
    const terminalReporter = new _metroTerminalReporter.MetroTerminalReporter(projectRoot, terminal);
    const reporter = {
        update (event) {
            terminalReporter.update(event);
            if (reportEvent) {
                reportEvent(event);
            }
        }
    };
    let metroConfig = await ExpoMetroConfig.loadAsync(projectRoot, {
        reporter,
        ...options
    });
    // TODO: When we bring expo/metro-config into the expo/expo repo, then we can upstream this.
    const { exp  } = (0, _config).getConfig(projectRoot, {
        skipSDKVersionRequirement: true,
        skipPlugins: true
    });
    const platformBundlers = (0, _platformBundlers).getPlatformBundlers(exp);
    metroConfig = await (0, _withMetroMultiPlatform).withMetroMultiPlatformAsync(projectRoot, metroConfig, platformBundlers);
    (0, _rudderstackClient).logEventAsync("metro config", (0, _getMetroProperties).getMetroProperties(projectRoot, exp, metroConfig));
    const { middleware , attachToServer , // New
    websocketEndpoints , eventsSocketEndpoint , messageSocketEndpoint ,  } = (0, _createDevServerMiddleware).createDevServerMiddleware(projectRoot, {
        port: metroConfig.server.port,
        watchFolders: metroConfig.watchFolders
    });
    const customEnhanceMiddleware = metroConfig.server.enhanceMiddleware;
    // @ts-ignore can't mutate readonly config
    metroConfig.server.enhanceMiddleware = (metroMiddleware, server)=>{
        if (customEnhanceMiddleware) {
            metroMiddleware = customEnhanceMiddleware(metroMiddleware, server);
        }
        return middleware.use(metroMiddleware);
    };
    middleware.use((0, _metroDebuggerMiddleware).createDebuggerTelemetryMiddleware(projectRoot, exp));
    const server1 = await Metro.runServer(metroConfig, {
        hmrEnabled: true,
        websocketEndpoints,
        // @ts-expect-error Property was added in 0.73.4, remove this statement when updating Metro
        watch: isWatchEnabled()
    });
    if (attachToServer) {
        // Expo SDK 44 and lower
        const { messageSocket , eventsSocket  } = attachToServer(server1);
        reportEvent = eventsSocket.reportEvent;
        return {
            server: server1,
            middleware,
            messageSocket
        };
    } else {
        // RN +68 -- Expo SDK +45
        reportEvent = eventsSocketEndpoint.reportEvent;
        return {
            server: server1,
            middleware,
            messageSocket: messageSocketEndpoint
        };
    }
}
function isWatchEnabled() {
    if (_env.env.CI) {
        _log.Log.log(_chalk.default`Metro is running in CI mode, reloads are disabled. Remove {bold CI=true} to enable watch mode.`);
    }
    return !_env.env.CI;
}

//# sourceMappingURL=instantiateMetro.js.map