"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.parsePlatformHeader = parsePlatformHeader;
exports.resolvePlatformFromUserAgentHeader = resolvePlatformFromUserAgentHeader;
exports.assertMissingRuntimePlatform = assertMissingRuntimePlatform;
exports.assertRuntimePlatform = assertRuntimePlatform;
var _url = require("url");
var _errors = require("../../../utils/errors");
const debug = require("debug")("expo:start:server:middleware:resolvePlatform");
function parsePlatformHeader(req) {
    var ref;
    const url = (0, _url).parse(req.url, /* parseQueryString */ true);
    const platform = ((ref = url.query) == null ? void 0 : ref.platform) || req.headers["expo-platform"] || req.headers["exponent-platform"];
    var ref1;
    return (ref1 = Array.isArray(platform) ? platform[0] : platform) != null ? ref1 : null;
}
function resolvePlatformFromUserAgentHeader(req) {
    let platform = null;
    const userAgent = req.headers["user-agent"];
    if (userAgent == null ? void 0 : userAgent.match(/Android/i)) {
        platform = "android";
    }
    if (userAgent == null ? void 0 : userAgent.match(/iPhone|iPad/i)) {
        platform = "ios";
    }
    debug(`Resolved platform ${platform} from user-agent header: ${userAgent}`);
    return platform;
}
function assertMissingRuntimePlatform(platform) {
    if (!platform) {
        throw new _errors.CommandError("PLATFORM_HEADER", `Must specify "expo-platform" header or "platform" query parameter`);
    }
}
function assertRuntimePlatform(platform) {
    const stringifiedPlatform = String(platform);
    if (![
        "android",
        "ios",
        "none"
    ].includes(stringifiedPlatform)) {
        throw new _errors.CommandError("PLATFORM_HEADER", `platform must be "android", "ios", or "none". Received: "${platform}"`);
    }
}

//# sourceMappingURL=resolvePlatform.js.map