#version 330 core

layout(location = 0) in vec3 os_pos;
layout(location = 1) in vec3 os_norm;

uniform mat4 modelmat;
uniform mat4 mvp;

vec3 sph_light( vec3 in_ws_norm ) {
	const float C1 = 0.429043f;
	const float C2 = 0.511664f;
	const float C3 = 0.743125f;
	const float C4 = 0.886227f;
	const float C5 = 0.247708f;

	// Constants for Old Town Square lighting
	const vec3 L00  = vec3( 0.871297f,  0.875222f,  0.864470f);
	const vec3 L1m1 = vec3( 0.175058f,  0.245335f,  0.312891f);
	const vec3 L10  = vec3( 0.034675f,  0.036107f,  0.037362f);
	const vec3 L11  = vec3(-0.004629f, -0.029448f, -0.048028f);
	const vec3 L2m2 = vec3(-0.120535f, -0.121160f, -0.117507f);
	const vec3 L2m1 = vec3( 0.003242f,  0.003624f,  0.007511f);
	const vec3 L20  = vec3(-0.028667f, -0.024926f, -0.020998f);
	const vec3 L21  = vec3(-0.077539f, -0.086325f, -0.091591f);
	const vec3 L22  = vec3(-0.161784f, -0.191783f, -0.219152f);

	vec3 DiffuseColor;
	DiffuseColor =  C1 * L22 * (in_ws_norm.x * in_ws_norm.x - in_ws_norm.y * in_ws_norm.y) +
					C3 * L20 * in_ws_norm.z * in_ws_norm.z +
					C4 * L00 -
					C5 * L20 +
					2.0f * C1 * L2m2 * in_ws_norm.x * in_ws_norm.y +
					2.0f * C1 * L21  * in_ws_norm.x * in_ws_norm.z +
					2.0f * C1 * L2m1 * in_ws_norm.y * in_ws_norm.z +
					2.0f * C2 * L11  * in_ws_norm.x +
					2.0f * C2 * L1m1 * in_ws_norm.y +
					2.0f * C2 * L10  * in_ws_norm.z;

	//DiffuseColor *= ScaleFactor;

	return DiffuseColor;
}

out vec3 ws_norm;
out vec3 col;

void main()
{
	gl_Position = mvp * vec4( os_pos, 1.0f );
	ws_norm = ( modelmat * vec4( os_norm, 0.0f )).xyz;
	col = sph_light( -normalize(ws_norm) ); //note: treat as background, color from direction of sph
}
