#version 330 core

layout(location = 0) in vec3 os_pos;
layout(location = 1) in vec3 os_norm;
layout(location = 2) in vec2 os_texcoord0;

uniform mat4 modelmat;
uniform mat4 mvp;
uniform vec4 ws_eye_pos;
uniform vec4 time;
uniform vec4 offset_magnitude;

out vec3 ws_norm;
out vec3 ws_eyevec;
out vec2 texcoord0;

void main()
{
	//float ofs = 15 * sin ( gl_VertexID + 5*time.x );

	float ofs = 100.0f;
	//TODO: to animate
	//float ofs = 25.0f * sin( 5 * time.x );
	//vec3 pos = os_pos  + (normalize(os_pos) * os_texcoord0.yyy * 150 * offset_magnitude.xxx );
	vec3 pos = os_pos - (normalize(os_pos) * os_texcoord0.yyy * ofs * offset_magnitude.xxx );
	//vec3 pos = os_pos;

	gl_Position = mvp * vec4( pos, 1.0f );
	ws_norm = ( modelmat * vec4( os_norm, 0.0f )).xyz;

	vec3 ws_pos = (modelmat * vec4( os_pos, 1.0f )).xyz;
	ws_eyevec = normalize( ws_eye_pos.xyz - ws_pos );

	texcoord0  = os_texcoord0;
}
