#version 330 core

layout(location = 0, index = 0) out vec4 out_color0;

in vec3 ws_norm;
in vec3 vs_pos;
in vec3 vs_norm;

float sat( float a ) {
	return clamp( a, 0, 1 );
}

vec3 refl( vec3 ws_n )
{
	float upfacing = 0.5 * pow( sat(ws_n.y+0.025), 5 );
	
	vec3 r = upfacing * vec3( 1, 1, 1 );
	
	return r;
}

void main()
{
	float dp = 1-dot( normalize(-vs_pos), normalize(vs_norm) );
	dp = 0.5 * sat( pow( dp + 0.2, 4 ) );

	vec3 ws_n = normalize( ws_norm );
	float upfacing = 0.75 * pow( sat(ws_n.y+0.05), 5 );
	
	//upfacing += step( 0.7, ws_n.y );
	//out_color0 = vec4( vec3(upfacing), 1.0); return;

	//TODO: envmap, 3D noise or 2D noise -> octahedral mapping

	vec3 base_col = 0.5 * vec3(1,0.75f,0.3f);
	vec3 refl_col = vec3( 1, 1, 1 );
	float refl = dp + upfacing;
	
	out_color0 = vec4( base_col + refl_col * refl, 1 );
}
