;60x2=32
;draws 60 stars, all of them twice
;Needs 32 bytes of memory.

;Basic idea:

;In a window of 19 characters width, repeat typing
;	"     *" (5 spaces + 1 star), and you get this:
;|12345*12345*12345*1|
;|2345*etc. *     *  |
;|   *     *     *   |
;|  *     *     *    | etc.

;For simpler code, we proceed in the other direction:
;	every star is 6 to the left of the previous one,
;	if x<0, 19 is added to the (negative) x-value
;	and we go one line down.
;|*     *     *     *| 19, 13, 7, 1, (-5) ->
;| *     *     *     | 14, 8, 2, (-4) ->
;|  *     *     *    | 15, 9, 3, (-3) etc.
;|   *     *     *   | etc.

;The desired pattern is just these two combined.

;So, all we have to do is start in the correct position (x=15)
;	and mirror every star to the other side of the line.
;(In the lines with only 3 stars, they are all drawn twice
;	but that doesn't hurt. Actually, in the last line, not
;	all stars)


;firmware call
txt_out equ #bb5a

;firmware cursor variables
;These have to be changed in order to work on the CPC464
cur_y equ #b726
cur_x equ #b727
;(*unlike firmware calls, these are 0,0 indexed!!!)

org #bae0	;It's ugly but it must be located here so that we can call the
			;txt_out routine with a relative jump.
			;In fact, we overwrite some bytes of the high jump block firmware
			;routines, but that doesn't affect the functionality of this code.

ld a,14					;initial x value (middle star 1st row)
ld bc,59*256 + 18		;b=total amount of stars (of one diagonal pattern) -1
						;c=18 (width-1)
	main_loop:
	ld hl,cur_x			;(re)set hl to the firmware x coord
	ld d,a				;backup x
	call draw_star		;draw original star @ x
	ld a,c				;mirror x:
	sub d				;x-=18
	;call draw_star		;draw mirrored star @ 18-x
	ld a,d				;restore x
	sub 6				;go 6 char positions left
	jr nc,loop_end		;check if <0
		;line break:
		dec hl			;hl <- cur_y
		inc (hl)		;line down
		adc c			;x+=18+1
	loop_end:
	djnz main_loop		;repeat that for 60 stars
	;fall through for the last star - it doesn't have to be mirrored,
	;because in the last line the mirrored stars are redundant:
draw_star:
	ld (hl),a			;set firmware x
	ld a,"*"			;again 42, the Answer to the Ultimate Question!
	jr txt_out			;relative jump because we located the program
	 					;close enough. (Jump instead of call because it's
						;the end of our subroutine/program and we use the
						;RET provided by the firmware routine.
