/** 
	ZigZag drawing method. Draws six zigzagging lines to form
    a three by three diamond pattern.
 	- Routine: 51 bytes
	- Filesize: 53 bytes
	- Start with SYS 4096
*/

* = 4096

.const      scroll_down   = $e981 // kernal routine, pushes screen contents down by one line.

.const      right_offset  = $02   // 0 at startup.
.const      left_offset   = $b3   // 3 at startup.
.const      repeat_count  = $7f   // 10 at startup.
.const      screen_ptr    = $0e   // $0400 aka. pointer to beginning of screenram.

opening:    jsr print_row         // print stars to the top row of the screen.
            dec repeat_count
            beq *                 // stop here when done.
            inc right_offset      // inc right and dec left to widen.
            dec left_offset
            bne opening           // loop back three times.

closing:    jsr print_row         // print stars to the top row of the screen.
            inc left_offset       // inc left and dec right to narrow.
            dec right_offset
            bne closing           // loop back three times.
            beq opening           // when done, loop back to beginning.

print_row:  jsr scroll_down       // push screen contents down one line.
            lda #'*'
            ldy left_offset       // draw left sides of the diamonds
            sta (screen_ptr),y    // save one byte by using a lucky pointer to $0400 on zero page
            sta $0406,y
            sta $040c,y
            ldy right_offset      // draw right sides of the diamonds
            sta $0403,y
            sta $0409,y
            sta $040f,y
            rts