; C64 alternate entry for VCCC2023 by GeirS, 2023-12-23
; Size: 46 bytes excl. load address. Assemble using 64tass.
; Requires loading at specific address (e.g. LOAD"CODE",8,1) and SYS 249 to start.

ScrollUp        = $e8ea             ; Scrolls the screen upwards
LastRow         = $07c0             ; Address of last screen row

                * = $f7             ; Load address

RowLoop         sty TableIdx+1      ; Save y (self-modifying code)
Start           jsr ScrollUp        ; Scroll screen upwards
TableIdx        ldy #6              ; Get current table index
SectionLoop     lda BitPatterns,y   ; Get bit pattern from table
CharLoop        asl                 ; Shift leftmost bit into carry flag
                bcc SkipChar        ; Branch if no asterisk here
                pha
                lda #42             ; Asterisk char
                sta LastRow+9,x     ; Put on last screen row three times
                sta LastRow+15,x
                sta LastRow+21,x
                pla
SkipChar        dex
                bne CharLoop        ; Loop until x is zero
                dey
                bpl RowLoop         ; Loop for seven rows
                ldy #6              ; Reset table index
                dec $76             ; This location contains value 2 at startup
                bpl SectionLoop     ; Loop for three sections
                rts
BitPatterns     .char $10,$28,$44,$82,$44,$28,$10
