; C64 entry for VCCC2023 by GeirS, 2023-12-23
; Size: 46 bytes excl. load address and BASIC stub. Assemble using 64tass.

Clsr            = $e544             ; Clears the screen
Plot            = $e50c             ; Sets the cursor position
Pnt             = $d1               ; Pointer to current screen line
Dirs            = $ac               ; Current directions for x and y (0 and 0)
Coords          = $b3               ; Current coordinates for x and y (3 and 0)

                * = $0801           ; Load address
; BASIC stub
                .word (NextLine),1337
                .null $9e,format("%4d",Start)
NextLine        .word 0

; Code (46 bytes)
Start           jsr Clsr            ; Clear the screen
OuterLoop       ldx #2-1            ; Two coordinates to process (x and y)
InnerLoop       ldy Coords,x        ; Get current coordinate
                lda Dirs,x
                lsr                 ; Shift direction bit into carry flag
                bcc Increment
                dey
                beq ToggleDir       ; Branch if minimum value reached
                .char $24           ; Instruction 'bit $c8'
Increment       iny
                cpy #18             ; Maximum value reached?
                beq ToggleDir       ; Branch if yes
                tya
                and Dirs+1          ; Required "randomness"
                cmp #15             ; Force direction change?
                bne SetCoord        ; Branch if no
ToggleDir       dec Dirs,x          ; Change direction
SetCoord        sty Coords,x        ; Set new coordinate
                dex
                bpl InnerLoop       ; Loop for both coordinates
                ldx Coords+1        ; Row in x (y already contains column)
                jsr Plot            ; Set cursor position
                lda #42             ; Asterisk char
                sta (Pnt),y         ; Put on screen
                bne OuterLoop       ; Branch always
