INCLUDE "hardware.inc"

SECTION "Header", ROM0[$100]

	jp EntryPoint

	ds $150 - @, 0 ; Make room for the header

EntryPoint:
    ld sp, $E000
    ld a, 0
    ld [rNR52], a
WaitVBlank:
    ld a, [rLY]
    cp 144
    jp c, WaitVBlank

    ; Turn the LCD off
    ld a, 0
    ld [rLCDC], a
    ld de, Tiles
    ld hl, $9000
    ld bc, TilesEnd - Tiles
CopyTiles:
    ld a, [de]
    ld [hli], a
    inc de
    dec bc
    ld a, b
    or a, c
    jp nz, CopyTiles
    ld hl, $9800
    ld d, 4
    ld bc, 32-19
Pattern:
    ;;
    ld e, %11001000
    call MakeLineSub
    add hl, bc
    ;
    ld e, %11010100
    call MakeLineSub
    add hl, bc
    ;
    ld e, %11100010
    call MakeLineSub
    add hl, bc
    ;
    ld e, %11000001
    call MakeLineSub
    add hl, bc
    ;
    ld e, %11100010
    call MakeLineSub
    add hl, bc
    ;
    ld e, %11010100
    call MakeLineSub
    add hl, bc
    ;
    dec d
    jr nz, Pattern

    ; Turn the LCD on (straight from hello-gb - same pattern all over the place
    ld a, LCDCF_ON | LCDCF_BGON
    ld [rLCDC], a

    ; During the first (blank) frame, initialize display registers
    ld a, %11100100
    ld [rBGP], a
Loop:
    ; line counter
    ld d, 0
LoopDown:
    call Wait10
    inc d
    ld a, d
    ld [$ff42], a
    cp a, 7
    jr nz, LoopDown
LoopUp:
    call Wait10
    dec d
    ld a, d
    ld [$ff42], a
    cp a, 0
    jr nz, LoopUp
    ;
    jr LoopDown

Wait10:
    ld e, 32
Wait10Loop:
    call WaitVSYNC
    dec e
    jr nz, Wait10Loop
    ret

WaitVSYNC:
AgainStartVSync:
    ld a, [$ff44]
    cp a, 144
    jr nc, AgainStartVSync
AgainEndVSync:
    ld a, [$ff44]
    cp a, 0
    jr nz, AgainEndVSync
    ret
Done:
	jp Done

MakeLineSub:
    push bc
    ld b, 3
NextByte:
    ld c,e
CopyBit:
    ld a,c
    and 1
    ld [hli],a
    ld a,c
    srl a
    ld c,a
    cp %11
    jr nz, CopyBit
NextLoop:
    dec b
    jr z, LastBit
    jr NextByte
LastBit:
    ld a,e
    and 1
    ld [hli],a
    pop bc
    ret

SECTION "Tile data", ROM0

Tiles:
        db $00,$00, $00,$00, $00,$00, $00,$00, $00,$00, $00,$00, $00,$00, $00,$00
        db $92,$92, $54,$54, $38,$38, $fe,$fe, $38,$38, $54,$54, $92,$92, $00,$00
TilesEnd:
