nColumns = $02                                  ; To draw 3 columns per group
nGroups  = 179                                  ; To draw 3 groups (already 3 at startup so no need to initialize it)

LB       = $33                                  ; $33/$34 already points to 1st screen memory Page, so don't need
HB       = $34                                  ; to initilize them

*=4097
; BASIC LAUNCHER  ( 10 SYS4109 )

        BYTE    $0B, $12, $0A, $00, $9E, $34, $31, $30, $39, $00, $00, $00

        JSR 58719                               ; Clear the screen                                          
        LDA #8                                  ; Black background                              
        STA 36879                               ;

loop0
        LDA #3                                  ; 3 Diamonds on each group
        STA nColumns

loop1
        LDX #0                                  ; Pointer in structure 'positions'

loop2
        LDY positions,X                         ; We use Y as the index for every character in the diamond
        LDA #42                                 ; Character code for the '*'
        STA (LB,Y)                              ; Draw the character

        INX                                     ; Next position
        CPX #12                                 ; Completed the diamond?. If yes, let's do another column (Diamond)
        BNE loop2                               ;

        DEC nColumns                            ; Another column. If already done 3, change to the next group
        BEQ newGroup                            ; 
        LDA LB                                  ; Next column (Diamond) is 6 chars to the rigth
        CLC                                     ;
        ADC #6                                  ; No need to increase HB. With the chosen position Carry is always cleared
        STA LB                                  ; BCC instead of JMP to save one byte
        BCC loop1

newGroup
        DEC nGroups                             ; Next group
        BEQ end                                 ; If already done 3->End
        LDA LB                                  ;
        CLC                                     ; Next group starts 120 chars to the right (this is 4 complete lines
        ADC #120                                ; plus 12 chars from the previous one
        STA LB                                  ;
        BCC loop0                               ; At a certain point we need to change to second screen memory page
        INC HB                                  ;
        BNE loop0                               ; BNE instead of JMP to save one byte

end
        BCS end                                 ; Stay here to avoid 'READY' message (looks nicer this way :-)

positions
        BYTE    3,24,26,45,49,66                ;
        BYTE    72,89,93,112,114,135            ; Relative position (from LB/HB), for every char in the diamond