        device zxspectrum48
        org #FA2A - (code_start.incdec - code_start)
code_start 
.start  ; HL = 11563 0x2D2B
        ; BC = 0xFA13
        ; A = 0
        ; 0xFA2A is multipurpose magic constant:
        ; 1. 0xFA2A is the address of `dec c` instruction for Y increment/decrement
        ; 2. 0xFA = -6 for X decrement
        ; 3. 0x2A for "*" code
        ld d, c                 ; save 0x13 in D for width and height
        ld hl, .incdec          ; L = "*", HL = 0xFA2A
        ld b, 0x0F              ; X = 18 - 3, Y = 0
        dec c
.restart
        dec (hl)                ; make DEC C at .incdec
.row    ld a, c
        cp d                    ; check Y < height
        ret nc
.loop   ; XY must be in BC only
        call 0x200A             ; on exit a=b, hl==0x2d28
        ld a, l                 ; "*"
        rst 0x10                ; print char
        ld a, b                 ; decrement X by 6
        add h                   ; 0xFA = -6
        ld b, a                 ; save X
        jr c, .loop             ; if X >= 0, continue
            add d               ; else X = X + width
            ld b, a             ; save X
.incdec     db 0x0E             ; code of `dec c` + 1  ; Y increment/decrement
            jr nz, .row         ; > 19
            jr .restart
code_end

; ==========================================================================
    display /h, "ORG is ", code_start, /d, ", ", code_start
    display /d, "Code size is ", $ - .start

    emptytap xombs.tap
    savetap xombs.tap, CODE, "<><><>", code_start, code_end - code_start
