org $00
guard $90

osbyte = $fff4
oswrch = $ffee
osbyte_wait_for_vsync = 19
vdu_cls = 12
vdu_goto_xy = 31

max = 18 ; inclusive

; The main idea here is to apply the classic "bouncing ball" animation (without
; erasing the ball, so we get trails) to a 19x19 sub-region at the top left
; of the screen. We have three "balls" which together generate the complete
; pattern. The code just runs forever, because why not?
;
; By putting the region at the top left instead of something more cosmetically
; pleasing, we can take advantage of implicit comparisons against zero at
; the top and left edges and thus save a few bytes by avoiding the need
; for a compare instruction or having to load Y explicitly with 1 in
; emit_bump_and_maybe_flip_direction when the ball bounces off the top or left
; edge.
;
; The code and data lives in zero page. The code probably doesn't benefit from
; this, although it doesn't hurt. It does save space to have the data in zero
; page so we can use zp,x addressing.
;
; For those unfamiliar with the Acorn OS, characters are written to the screen
; by loading them into A and calling OSWRCH (Operating System WRite CHaracter).
; The cursor can be moved to screen coordinate (X, Y) by sending the three bytes
; 31, X, Y in sequence via OSWRCH. Writing the single byte 12 clears the screen.
;
; The code is written in beebasm format, see https://github.com/stardot/beebasm.

; Uncomment the next line to add some extra code to slow the output down to make
; things (slightly) more interesting to look at. I am not counting the space
; taken by this as it isn't necessary to get the desired output.
; slow = TRUE
slow =? FALSE

macro waste_time
    if slow
        txa:pha
        lda #osbyte_wait_for_vsync:jsr osbyte
        lda #osbyte_wait_for_vsync:jsr osbyte
        lda #osbyte_wait_for_vsync:jsr osbyte
        pla:tax
    endif
endmacro

.start

    ; Five bytes wasted clearing the screen; grrr... I suspect this isn't
    ; technically required under rule 1.2.1, as the output we're clearing comes
    ; from the operating system, but the results look awful without this.
    lda #vdu_cls:jsr oswrch

.loop2
    ldx #coord_table_size-1
.loop
    lda #vdu_goto_xy:jsr oswrch
    jsr emit_bump_and_maybe_flip_direction     ; emit X coordinate
    dex:jsr emit_bump_and_maybe_flip_direction ; emit Y coordinate
    lda #'*':jsr oswrch
    waste_time
    dex:bpl loop
    bmi loop2 ; always branch

; Emit the value at coord_table,x via OSWRCH
; Add delta_table,x to coord_table,x
; If coord_table,x is now 0, set delta_table,x to 1
; If coord_table,x is now max, set delta_table,x to -1 ($ff)
.emit_bump_and_maybe_flip_direction
    lda coord_table,x:jsr oswrch
    tay
    clc:adc delta_table,x
    sta coord_table,x
    beq set_delta_to_y ; Y=1 if we branch here, as it's the old value of A
    cmp #max:bne rts
    ldy #$ff
.set_delta_to_y
    sty delta_table,x
.rts
    rts

.coord_table
    equb 1, 4   ;  y0,  x0
    equb 1, 10  ;  y1,  x1
    equb 1, 16  ;  y2,  x2
coord_table_size = * - coord_table
.delta_table
    equb 1, 1   ; dy0, dx0
    equb 1, 1   ; dy1, dx1
    equb 1, 1   ; dy2, dx2

.end

save "Star", start, end
print end-start, "bytes"
