#version 410

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;
uniform float size;
// Reports the frame time of the current frame, for animations.
uniform float osg_FrameTime;
uniform float t;
uniform float storm;
uniform float r_force;
uniform float color_scale;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec4 p3d_ViewMatrix;

// Output to fragment shader
out vec4 color;

float hash(float p){
    return fract(4768.1232345456 * sin(p));
}

float wave(vec4 uv, vec4 emitter, float speed, float phase, float timeshift){
    float dst = distance(uv, emitter);
    return exp(sin(dst * phase - timeshift * speed) - 1.0);
}
vec4 wavedrag(vec4 uv, vec4 emitter){
    return normalize(uv - emitter);
}
float seedWaves = 0.0;
vec4 randWaves(){
    float x = hash(seedWaves);
    seedWaves += 1.0;
    float y = hash(seedWaves);
    seedWaves += 1.0;
    float z = hash(seedWaves);
    seedWaves += 1.0;
    float w = hash(seedWaves);
    seedWaves += 1.0;
    return vec4(x,y,z,w) * 2.0 - 1.0;
}

float getwaves5d(vec4 position, float dragmult, float timeshift){
    float iter = 0.0;
    float phase = 6.0;
    float speed = 2.0;
    float weight = 1.0;
    float w = 0.0;
    float ws = 0.0;
    for(int i=0;i<20;i++){
        vec4 p = randWaves() * 30.0;
        float res = wave(position, p, speed, phase, 0.0 + timeshift);
        float res2 = wave(position, p, speed, phase, 0.006 + timeshift);
        position -= wavedrag(position, p) * (res - res2) * weight * dragmult;
        w += res * weight;
        iter += 12.0;
        ws += weight;
        weight = mix(weight, 0.0, 0.2);
        phase *= 1.2;
        speed *= 1.02;
    }
    return w / ws;
}

float wave_h(float my_x, float my_y, float my_t) {
	vec2 uv = vec2((my_x+10)/20, (my_y+10)/20);
	float water_h = getwaves5d(vec4(my_x*0.15, my_y*0.15, 0, 0.0), 15.0, my_t) * storm;
	return water_h;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

float rand(vec2 co){
  return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main() {
	vec4 new = p3d_Vertex;

    float age = -new.z -6 + t*0.5 - 1 + simplex3d(vec3(p3d_Vertex.x, p3d_Vertex.y, t*0.25));

    if (age > 0) {
        float factor = smoothstep(0, 2, age);
        new.x = mix(p3d_Vertex.x, p3d_Vertex.x + (rand(vec2(p3d_Vertex.x, p3d_Vertex.y))-0.5)*r_force, factor);
        new.y = mix(p3d_Vertex.y, p3d_Vertex.y + (rand(vec2(p3d_Vertex.y, p3d_Vertex.x))-0.5)*r_force, factor);
        new.z = wave_h(new.x, new.y, osg_FrameTime);
        seedWaves = 0.0;
        float diff = wave_h(new.x+0.02*20, new.y+0.02*20, osg_FrameTime);
        float diff_len = (diff - new.z)*5+0.5;
        new.z *= 5;
        float elev = new.z;
        new.z += -6;
        color = vec4(vec3(55.0/255.0/2.0, 88.0/255.0/2.0, 114.0/255.0/2.0) * diff_len*2, 1);
        color = mix(color, vec4(102.0/255.0, 142.0/255.0, 167.0/255.0, 1.0), smoothstep(1.1, 1.5, elev));
        new.z = mix(p3d_Vertex.z, new.z, factor);
        color = mix(p3d_Color, color, factor);

        if (color_scale > 1 && factor < 1) {
            color *= color_scale + simplex3d(vec3(new.x, new.y, osg_FrameTime));
//            color *= color_scale;
        }
    } else {
        color = p3d_Color;
    }

	gl_Position = p3d_ModelViewProjectionMatrix * new;
	gl_PointSize = size / length((p3d_ModelViewMatrix * new).xyz);
//	gl_Position = p3d_ModelViewProjectionMatrix * p3d_Vertex;
//	gl_PointSize = size / length((p3d_ModelViewMatrix * p3d_Vertex).xyz);
}
