#version 410

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;
uniform float size;
// Reports the frame time of the current frame, for animations.
uniform float osg_FrameTime;
uniform float px;
uniform float py;
uniform float pz;
uniform bool show;

uniform vec3 light;

uniform float neon;
uniform float mag;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec4 p3d_ViewMatrix;

uniform mat4 p3d_ModelMatrix;

// Output to fragment shader
out vec4 color;

void main() {

	if (show == true) {

		color.a = 1;

		if (px > 0) {
			color.rgb = mix(vec3(247.0/255.0, 69.0/255.0, 0.0/255.0), p3d_Color.rgb, pow(abs(sin(p3d_Vertex.x-osg_FrameTime*5)), px));
		} else if (py > 0) {
			color.rgb = mix(vec3(254.0/255.0, 213.0/255.0, 26.0/255.0), p3d_Color.rgb, pow(abs(sin(p3d_Vertex.y-osg_FrameTime*5)), py));
		} else if (pz > 0) {
			color.rgb = mix(vec3(167.0/255.0, 20.0/255.0, 0.0/255.0), p3d_Color.rgb, pow(abs(sin(p3d_Vertex.z-osg_FrameTime*5)), pz));
		} else {
			color.rgb = p3d_Color.rgb;
		}

		vec4 position = p3d_Vertex;

		vec4 space = p3d_ModelMatrix * position;  // trans_model_to_world <- tego chyba trzeba brać
//		float distance = length(space.xyz - light);
//		float turbo = smoothstep(2., 0., distance);
//		float distance = length(space.xyz - light);
//		float turbo = smoothstep(2., 0., length(space.xyz - light));

//		color = vec4(227/255., 222/255., 219/255., 1) * turbo * neon * mag + color * .8;
//		color.a = 1;
//		color = vec4( vec3(227/255., 222/255., 219/255.) * turbo * neon * mag + color.rgb * .8, 1);
		color = vec4( vec3(227/255., 222/255., 219/255.) * smoothstep(2., 0., length(space.xyz - light)) * neon * mag + color.rgb * .8, 1);

		gl_Position = p3d_ModelViewProjectionMatrix * p3d_Vertex;
		gl_PointSize = size / length((p3d_ModelViewMatrix * p3d_Vertex).xyz);
	} else {
		color.a = 0;
	}
}
