#version 410
#define SHIFT .8
#define MAX 5
#define DENSITY 7  // 5
//#define COL_1 vec3(53/255.0, 9/255., 7/255.)
//#define COL_3 vec3(118/255.0, 63/255., 24/255.)
//#define COL_5 vec3(183/255.0, 160/255., 54/255.)
#define COL_1 vec3(0.9803921568627451, 0.25882352941176473, 0.34901960784313724)
#define COL_3 vec3(0.984313725490196, 0.5450980392156862, 0.9372549019607843)
#define COL_5 vec3(0.5058823529411764, 0.011764705882352941, 0.07450980392156863)

// Uniform inputs
uniform float t;
uniform vec2 center;

uniform bool rounding;
uniform bool hole;
uniform bool clog;
uniform float hands_pos;
uniform float multi;

uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;

uniform float size;

uniform float ix;
uniform float iy;
uniform float iz;

uniform float fact;

// Reports the frame time of the current frame, for animations.
uniform float osg_FrameTime;

//layout (points) in;
//layout (points, max_vertices=1) out;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;

out vec4 color;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

void main() {
    vec4 position = p3d_Vertex;
    color = p3d_Color;

//	float new_size = size;

	if (rounding == true) {
		float dens = 1;
		float trans_speed = 0.25;

		vec3 intensity = vec3(0, 0, 0);
		intensity.x = smoothstep(-trans_speed, trans_speed, -cos(osg_FrameTime * 1.01 - 2.3));
		intensity.y = smoothstep(-trans_speed, trans_speed, -cos(osg_FrameTime * 1.22 - 2.3));
		intensity.z = smoothstep(-trans_speed, trans_speed, -cos(osg_FrameTime * 1.43 - 2.3));

		intensity.x = ix;
		intensity.y = iy;
		intensity.z = iz;

		vec4 new = position;
		new.x = mix(new.x, round(new.x * dens) / dens, intensity.x);
		new.y = mix(new.y, round(new.y * dens) / dens, intensity.y);
		new.z = mix(new.z, round(new.z * dens) / dens, intensity.z);

		position = new;

		color.r = mix(color.r, mix(color.r, 1.0, 0.25), intensity.x);
		color.g = mix(color.g, mix(color.g, 1.0, 0.25), intensity.y);
		color.b = mix(color.b, mix(color.b, 1.0, 0.25), intensity.z);
	}

	if (hole == true) {
//		float dist = length(vec2(SHIFT - position.x, (hands_pos - position.y) / 2));
		float dist = length(vec2(SHIFT - position.x, (hands_pos - position.y) / 2.1));
//		float magnet = 1 / dist * multi;
		float magnet = smoothstep(7, 0, dist) * 0.6 * multi;

		vec3 move;
		move.x = ( simplex3d(vec3(position.x, position.y, osg_FrameTime * 1.0)) +
		           simplex3d(vec3(position.y * 10, 0, 0)) * 20 );
		move.y = simplex3d(vec3(osg_FrameTime * 1.0, position.x, position.y));
		move.z = simplex3d(vec3(position.y, osg_FrameTime * 1.0, position.x));

		float orig_x = position.x;

		if ((SHIFT - position.x) < 0) {
			position.x += magnet * 7.0;  // 4.0
		} else {
			position.x -= magnet * 7.0;  // 4.0
		}
		position.z += magnet;

		position.xyz += move * magnet / 5;

		float mixing = smoothstep(3., 0., abs(SHIFT - orig_x)) * magnet * 2;
		if (mixing < 1/3.) {
			color.rgb = mix(color.rgb, COL_1, smoothstep(0., 1/3., mixing));
		} else if (mixing > 2/3.) {
			color.rgb = mix(COL_3, COL_5, smoothstep(2/3., 1., mixing));
		} else {
			color.rgb = mix(COL_1, COL_3, smoothstep(1/3., 2/3., mixing));
		}
//		color.rgb = vec3(mixing);
	}

//	if (bulb == true) {
//		vec4 space = p3d_ModelMatrix * position;  // trans_model_to_world <- tego chyba trzeba brać
//		vec3 light_pos = light;
//		light_pos.y += 0;
//		float distance = length(space.xyz - light_pos);
//		float turbo = smoothstep(2., 0., distance);
//		color = vec4(0, turbo, turbo, 1) + color * .8;
//		color.a = 1;
//
////		color.r = 1;
//	}

	if (clog == true) {
//		float fact = smoothstep(-1.5, 22, position.y);
//		float fact = smoothstep(0, 22, position.y);
		vec3 dist;
		dist.x = simplex3d(vec3(position.x*0.25, position.y*0.25, osg_FrameTime*0.25));
		dist.y = simplex3d(vec3(osg_FrameTime*0.25, position.x*0.25, position.y*0.25));
		dist.z = simplex3d(vec3(position.y*0.25, osg_FrameTime*0.25, position.x*0.25));
		position.xyz = mix(position.xyz, (round(position*DENSITY)/DENSITY).xyz+dist, fact);
		vec4 dan = vec4(111.0/255.0, 48.0/255.0, 150.0/255.0, 1.0);
		dan.rgb += dist*1.0;
		color = mix(color, dan, fact);
//		new_size = mix(30, size, fact);
	}

	gl_Position = p3d_ModelViewProjectionMatrix * position;

	//	} else {
//		color.a = 0;
//		gl_Position = p3d_ModelViewProjectionMatrix * position;
//	}

	gl_PointSize = size / length((p3d_ModelViewMatrix * p3d_Vertex).xyz);

}