#version 410
#define DENSITY 7  // 5
#define BORDER 1.5
#define S_FREQ 10
#define S_AMP 2
#define T_FREQ_XZ .5
#define T_FREQ_T .2
#define T_AMP 2

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;
uniform float osg_FrameTime;
uniform float size;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec4 p3d_ViewMatrix;

// Output to fragment shader
out vec4 color;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

void main() {
	vec4 position;

	if (p3d_Vertex.y < BORDER) {

		vec3 s_add = vec3(
			simplex3d(p3d_Vertex.xyz * S_FREQ),
			simplex3d(p3d_Vertex.yzx * S_FREQ),
			simplex3d(p3d_Vertex.zxy * S_FREQ)
		);

		vec3 t_add = vec3(
			simplex3d(vec3(-p3d_Vertex.x * T_FREQ_XZ, -p3d_Vertex.y * T_FREQ_XZ, osg_FrameTime * T_FREQ_T)),
			simplex3d(vec3(osg_FrameTime * T_FREQ_T, -p3d_Vertex.x * T_FREQ_XZ, -p3d_Vertex.y * T_FREQ_XZ)),
			simplex3d(vec3(-p3d_Vertex.y * T_FREQ_XZ, osg_FrameTime * T_FREQ_T, -p3d_Vertex.x * T_FREQ_XZ))
		);

		position = vec4(p3d_Vertex.xyz + (s_add * S_AMP + t_add * T_AMP) * smoothstep(BORDER, -18., p3d_Vertex.y), p3d_Vertex.w);
		color = vec4(mix(p3d_Color.rgb, vec3(1), smoothstep(-17., -18., position.y)), 1);

	} else {

		float fact = smoothstep(BORDER, 17., p3d_Vertex.y);
		vec3 dist = vec3(
			simplex3d(vec3(p3d_Vertex.xy, osg_FrameTime) * 0.25),
			simplex3d(vec3(osg_FrameTime, p3d_Vertex.xy) * 0.25),
			simplex3d(vec3(p3d_Vertex.y, osg_FrameTime, p3d_Vertex.x) * 0.25)
		);
		position = vec4(mix(p3d_Vertex.xyz, (round(p3d_Vertex*DENSITY)/DENSITY).xyz+dist, fact), p3d_Vertex.w);
		color = vec4(mix(p3d_Color.rgb, vec3(111/255., 48/255., 150/255.) + dist, fact), 1);

	}

	gl_Position = p3d_ModelViewProjectionMatrix * position;
	gl_PointSize = size / length((p3d_ModelViewMatrix * position).xyz);
}
