#version 410
#define MARGIN 25.4
#define TOP_UP -0.3
#define TOP_DN TOP_UP - 1.6
#define BOT_UP -9.7
#define BOT_DN BOT_UP - 1.6

#define DENSITY 7
#define PERIOD radians(360)

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;

uniform sampler2D greetings_0;
uniform sampler2D greetings_1;
uniform float t;
uniform float osg_FrameTime;
uniform float share;
uniform float mono;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;

// Output to fragment shader
out vec4 color;

float rand(vec2 co){
  return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

void main() {
	vec4 position = p3d_Vertex;
//	if (rand(vec2(gl_VertexID, p3d_Vertex.y)) > 0.1) {
	if (rand(vec2(p3d_Vertex.x*p3d_Vertex.z, p3d_Vertex.y+p3d_Vertex.z)) > share) {
		position.z = 1000;
	}

	//	Mono palette
	color = p3d_Color;
//	float mono = 1.0;
	float lum = dot(vec3(0.299, 0.587, 0.114), p3d_Color.rgb);
//	color.rgb = mix(p3d_Color.rgb, vec3(27.0/255.0, 52.0/255.0, 113.0/255.0) * lum, mono);
//	color.rgb = mix(p3d_Color.rgb, vec3(32/255., 33/255., 38/255.) * lum, mono);
//	color.rgb = mix(p3d_Color.rgb, vec3(35/255., 43/255., 44/255.) * lum, mono);
//	color.rgb = mix(p3d_Color.rgb, vec3(54/255., 65/255., 65/255.) * lum, mono);
//	color.rgb = mix(p3d_Color.rgb, vec3(80/255., 80/255., 75/255.) * lum, mono);  // Ten byl niezly
//	color.rgb = mix(p3d_Color.rgb, vec3(83/255., 76/255., 69/255.) * lum, mono);  // Za jasny
	color.rgb = mix(p3d_Color.rgb, vec3(56/255., 59/255., 57/255.) * lum, mono);  // Fajny
//	color.rgb = mix(p3d_Color.rgb, vec3(52/255., 52/255., 52/255.) * lum, mono);  // Nie

	if (p3d_Vertex.x < BOT_UP && p3d_Vertex.x > BOT_DN && p3d_Vertex.y > -MARGIN && p3d_Vertex.y < MARGIN && p3d_Vertex.z < -6) {
		vec2 uv = vec2(-(p3d_Vertex.y-MARGIN)/120 - (t*.9-0.22), p3d_Vertex.x/1.7-0.33);  // 0.156
		vec4 probe = texture(greetings_1, uv);
		color.rgb = mix(color.rgb, probe.rgb, probe.a);
//		if (probe.r > .5) {
//			color = mix(vec4(1, 1, 1, 1), color, 0.0);
//		}
	} else if (p3d_Vertex.x < TOP_UP && p3d_Vertex.x > TOP_DN && p3d_Vertex.y > -MARGIN && p3d_Vertex.y < MARGIN && p3d_Vertex.z < -6) {
//		vec2 uv = vec2(-(p3d_Vertex.y-MARGIN)/120 + (t*.5+0.05), p3d_Vertex.x/1.7+0.10);
		vec2 uv = vec2(-(p3d_Vertex.y-MARGIN)/120 + (t*.5+0.10), p3d_Vertex.x/1.7+0.10);
		vec4 probe = texture(greetings_0, uv);
		color.rgb = mix(color.rgb, probe.rgb, probe.a);
//		if (probe.r > .5) {
//			color = mix(vec4(1, 1, 1, 1), color, 0.0);
//		}
	}

	if (p3d_Vertex.x < TOP_DN && p3d_Vertex.x > BOT_UP) {
//		float fact = smoothstep(-9, 17, position.y);
//		fact = 1;

		float fact = (0.5 - cos((p3d_Vertex.x - BOT_UP) / (TOP_DN - BOT_UP) * PERIOD) * 0.5) * mono;

		vec3 dist;
		dist.x = simplex3d(vec3(position.x*0.25, position.y*0.25, osg_FrameTime*0.25));
		dist.y = simplex3d(vec3(osg_FrameTime*0.25, position.x*0.25, position.y*0.25));
		dist.z = simplex3d(vec3(position.y*0.25, osg_FrameTime*0.25, position.x*0.25));
		position.xyz = mix(position.xyz, (round(position*DENSITY)/DENSITY).xyz+dist, fact);
		vec4 dan = vec4(111.0/255.0, 48.0/255.0, 150.0/255.0, 1.0);
		dan.rgb += dist*1.0;
//		color = mix(p3d_Color, dan, fact);
		color = mix(color, dan, fact);
//		color.rgb = vec3(fact);
	}

	gl_Position = p3d_ModelViewProjectionMatrix * position;
	gl_PointSize = 39 / length((p3d_ModelViewMatrix * p3d_Vertex).xyz);


	color.a = 1 - (p3d_Vertex.z + 7.37051) / 5;  // 5

//	color = vec4( vec3(gl_Position.z / 10), 1);
}
