#version 410
#define HALF_PI radians(90)

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform float t;
uniform float s;
uniform float freq;
uniform float force;
uniform float anom_freq;
uniform float anom_force;
uniform float lifespan;
uniform bool door;
uniform float start;
uniform float stop;
uniform float direction;
uniform bool kramsta;
uniform float bound_1;
uniform float bound_2;
uniform float color_scale;
uniform bool paint;
uniform sampler2D paint_tex;

uniform mat4 p3d_ModelViewMatrix;

uniform float size;


// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec2 p3d_MultiTexCoord0;

// Output to fragment shader
//out vec2 texcoord;
out vec4 color;

//out float pointsize;

// Notes
// http://www.science-and-fiction.org/rendering/noise.html
// https://shadertoyunofficial.wordpress.com/2019/01/02/programming-tricks-in-shadertoy-glsl/
// https://en.wikipedia.org/wiki/Perlin_noise
// https://en.wikipedia.org/wiki/Simplex_noise
// https://www.shadertoy.com/view/XsX3zB

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

void main() {
	float progress = smoothstep(0.0, 1.0, ((t + simplex3d(vec3(-p3d_Vertex.x * anom_freq, -p3d_Vertex.y * anom_freq, -p3d_Vertex.z * anom_freq)) * anom_force) * (stop + lifespan - start) + start + p3d_Vertex.y * direction) / lifespan);

	vec3 range = vec3(
		simplex3d(vec3(p3d_Vertex.z * freq, p3d_Vertex.y * freq, p3d_Vertex.x * freq)),
		simplex3d(vec3(p3d_Vertex.y * freq, p3d_Vertex.x * freq, p3d_Vertex.z * freq)),
		simplex3d(vec3(p3d_Vertex.x * freq, p3d_Vertex.z * freq, p3d_Vertex.y * freq))
	);
	vec3 angle = (range * 2.0 + 2.0) * progress * HALF_PI;

	vec3 multiplier = (1.0 - cos(angle)) * force;

	vec4 new;
	if ((kramsta && p3d_Vertex.y > -start) || (kramsta && (p3d_Vertex.x > bound_1 || p3d_Vertex.x < bound_2))) {
		new = p3d_Vertex;
		color = p3d_Color;
	} else {
		new = vec4(
			p3d_Vertex.x + simplex3d(vec3(p3d_Vertex.x * freq, p3d_Vertex.y * freq, p3d_Vertex.z * freq)) * multiplier.x,
			p3d_Vertex.y + simplex3d(vec3(p3d_Vertex.y * freq, p3d_Vertex.z * freq, p3d_Vertex.x * freq)) * multiplier.y,
			p3d_Vertex.z + simplex3d(vec3(p3d_Vertex.z * freq, p3d_Vertex.x * freq, p3d_Vertex.y * freq)) * multiplier.z,
			p3d_Vertex.w
		);
	    color = vec4(p3d_Color.rgb, 1.0 - progress);
	}

	if (paint == true) {
		vec2 tex_size = textureSize(paint_tex, 0);
		float pw = tex_size.x/tex_size.y*2;
		if (p3d_Vertex.x > 1 && p3d_Vertex.z < 1.45 && p3d_Vertex.z > -0.55 && p3d_Vertex.y > -1.55-pw/2 && p3d_Vertex.y < -1.55+pw/2) {
			vec2 uv = vec2((p3d_Vertex.y -(-1.55-pw/2))/pw, (p3d_Vertex.z -(-0.55))/2);
			vec2 add;
			add.x = simplex3d(vec3(p3d_Vertex.y*10, p3d_Vertex.z*10, s));
			add.y = simplex3d(vec3(s, p3d_Vertex.y*10, p3d_Vertex.z*10));
			vec4 tex_color = texture(paint_tex, uv+add*(1-s)*0.25);
			color.rgb = mix(color.rgb, tex_color.rgb, tex_color.a*s);
		}
	}

    gl_Position = p3d_ModelViewProjectionMatrix * new;
	gl_PointSize = size / length((p3d_ModelViewMatrix * new).xyz);
}
