#version 410

#define SPARKS 113  // 256, 128
#define STEP 4  // 4
#define SPREAD_Z 2.9  // 2.7
#define SPREAD_X 3.6  // 5.2, 2.0
#define SPEED 20000
#define HALF_PI radians(90)
#define PI radians(180)
#define TWO_PI radians(360)

// Uniform inputs
//uniform mat4 p3d_ModelViewProjectionMatrix;
uniform float t;
uniform float freq;
uniform float force;
//uniform float irreg_freq;
//uniform float irreg_amp;
uniform float lifespan;
uniform bool door;
uniform float start;
//uniform float stop;
uniform float direction;
uniform bool kramsta;
uniform float bound_1;
uniform float bound_2;

uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;
uniform float size;
uniform bool show;
uniform float osg_FrameTime;
//float t = osg_FrameTime;

uniform float irreg_freq;  // irregularity frequency 2.5
uniform float irreg_amp;  // irregularity amplitude 1
uniform float dec_r;  // decay rate 0.5

uniform float a_long;  // longitudinal acceleration 1
uniform float v_long;  // longitudinal velocity
uniform float a_lat;  // latitudinal acceleration .01
uniform float v_lat;  // latitudinal velocity .4

uniform float freq_long;  // 10
uniform float freq_lat;  // 1

uniform float wup;  // warm-up period 1
uniform float flp;  // flight period 2

uniform float bi;  // burn intensity 0.5
uniform float ba;  // burn alpha 0.5

uniform float right;
uniform float left;

uniform float ang;

layout (points) in;
//layout (line_strip, max_vertices=2) out;
layout (points, max_vertices=SPARKS) out;

in vec4[1] vert_color;
//uniform vec4 p3d_Color;
out vec4 color;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);
//
//
float rand(vec2 co)
{
    return fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453);
}
//
//const float PI = 3.1415926535897932384626433832795028841971693993751058209749;
//
//float getPhi(in float y, in float x)
//{
//    float ret;
//    if (x == 0.0) {
//        if (y == 0.0) {
//            ret = 0.0;
//        } else if (y > 0.0) {
//            ret = PI/2.0;
//        } else {
//            ret = -1.0 * PI/2.0;
//        }
//    } else if (x > 0.0) {
//        ret = atan(y/x);
//    } else if (x < 0.0) {
//        if (y >= 0.0) {
//            ret = atan(y/x) + PI;
//        } else {
//            ret = atan(y/x) + PI;
//        }
//    }
//    return ret;
//}
//
//vec3 toPolar(in vec3 cart)
//{
//    float xySquared = (cart.x * cart.x) + (cart.y * cart.y);
//    float radius = sqrt(xySquared + (cart.z * cart.z));
//    return vec3(radius, atan(sqrt(xySquared), cart.z), getPhi(cart.y, cart.x));
//}
//
//vec3 toCartesian(in vec3 sph) {
//    return vec3(
//        sin(sph.y) * cos(sph.z) * sph.x,
//        sin(sph.y) * sin(sph.z) * sph.x,
//        cos(sph.y) * sph.x
//    );
//}

void main() {

    vec4 position = gl_in[0].gl_Position;

    gl_Position = p3d_ModelViewProjectionMatrix * position;
	gl_PointSize = size / length((p3d_ModelViewMatrix * position).xyz);

//    vec4 color = vert_color[0];
    vec4 my_color = mix(vert_color[0], vec4(224.0/255.0, 64.0/255.0, 21.0/255.0, 1), 0.125);
    color = vec4(my_color.rgb, 1);

//    float irreg_freq = 2.5;  // irregularity frequency 2.5
//	float irreg_amp = 1;  // irregularity amplitude 1
//	float dec_r = 0.5;  // decay rate 0.5
//
//	float a_long = 3;  // longitudinal acceleration 1
//	float v_long = 0;  // longitudinal velocity
//	float a_lat =  0.1;  // latitudinal acceleration .01
//	float v_lat =  0.4;  // latitudinal velocity .4
//
//	float freq_long = 10;  // 10
//	float freq_lat = 1;  // 1
//
//	float wup = 1;  // warm-up period 1
//	float flp = 2;  // flight period 2
//
//	float bi = 0.5;  // burn intensity 0.5
//	float ba = 0.5;  // burn alpha 0.5

	float flt;  // flight time

    float delay = simplex3d(
        vec3(position.y * irreg_freq, position.x * irreg_freq, position.z * irreg_freq)
	) * irreg_amp;

//	float age = t * dec_r - (-position.y - start + delay - position.z);
	float age = t * dec_r - (-position.y - start + delay);
//	float age = t * dec_r - (-position.y - start + delay - position.x);
	flt = max(age - wup, 0);

	float mult_long = a_long * pow(flt, 2) + v_long * flt;
	float mult_lat = a_lat * pow(flt, 2) + v_lat * flt;

//	float right = 0.0;
//	float left = -1.1;

    if (show == true) {
        if (age > 0) {
			vec3 new = vec3(
				simplex3d(vec3(position.x * freq_long, position.z * freq_long, flt * freq_lat)) * mult_lat,
				-mult_long,
				simplex3d(vec3(position.z * freq_long, position.x * freq_long, flt * freq_lat)) * mult_lat
			);
			position.xyz += new;
//			vec3 blend_col = vec3(1, .5, .25);
			vec3 blend_col = vec3(224.0/255.0, 64.0/255.0, 21.0/255.0);
//			vec3 blend_col = vec3(.25, .5, 250/255);
			if (age < wup) {
				color = vec4(mix(color.rgb, blend_col, smoothstep(0, wup, age) * bi), 1 - smoothstep(0, wup, age) * (1 - ba));
			} else {
				color = vec4(mix(color.rgb, blend_col, bi), smoothstep(wup + flp, wup, flt) * ba);
	//			vert_color = vec4(mix(p3d_Color.rgb, vec3(1, 0, 0), bi), 0);
			}
			gl_Position = p3d_ModelViewProjectionMatrix * position;
			gl_PointSize = size / length((p3d_ModelViewMatrix * position).xyz);
	        EmitVertex();
        } else {
			EmitVertex();

			if (
				position.z < -2.02 && (
					position.x < (2.19998-1.09248)/2 || position.x > (2.19998-1.09248)/2 && rand(position.xy) < right
				)
			) {
                for (int i = SPARKS; i >= 0; i--) {

                    vec4 position = gl_in[0].gl_Position;
                    float advance = float(i)/SPARKS;

					float rand_1 = rand(+vec2(i-int(osg_FrameTime*SPEED/SPARKS), +position.y));
					float rand_2 = rand(-vec2(i-int(osg_FrameTime*SPEED/SPARKS), -position.y))-0.5;

                    position.z += SPREAD_Z * rand_1 * sin(rand_2 * PI + ang) * advance;
                    position.x += SPREAD_X * rand_1 * cos(rand_2 * PI + ang) * advance;

                    position.y -= STEP*advance;
                    gl_Position = p3d_ModelViewProjectionMatrix * position;
					gl_PointSize = size / length((p3d_ModelViewMatrix * position).xyz);

                    if (advance < 1.0/3) {
                        color = mix(vec4(254.0/255.0, 254.0/255.0, 172.0/255.0, 1), vec4(254.0/255.0, 197.0/255.0, 21.0/255.0, 1), advance*3);
                    } else if (advance >= 1.0/3 && advance < 2.0/3) {
                        color = mix(vec4(254.0/255.0, 197.0/255.0, 21.0/255.0, 1), vec4(193.0/255.0, 12.0/255.0, 0.0/255.0, 1), advance*3-1);
                    } else {
                        color = mix(vec4(193.0/255.0, 12.0/255.0, 0.0/255.0, 1), vec4(193.0/255.0, 12.0/255.0, 0.0/255.0, 0), advance*3-2);
                    }
                    EmitVertex();
                }
            }

			if ( position.z >= -2.02 && position.x < left && rand(position.yz) < 0.01 ) {
                for (int i = SPARKS; i >= 0; i--) {

                    vec4 position = gl_in[0].gl_Position;
                    float advance = float(i)/SPARKS;
                    position.z += SPREAD_Z * rand(vec2(i-int(osg_FrameTime*SPEED/SPARKS), position.y)) * advance;
                    position.x += SPREAD_X/2 * (rand(-vec2(i-int(osg_FrameTime*SPEED/SPARKS), -position.y))) * advance;
                    position.y -= STEP*advance;
                    gl_Position = p3d_ModelViewProjectionMatrix * position;
					gl_PointSize = size / length((p3d_ModelViewMatrix * position).xyz);

                    if (advance < 1.0/3) {
                        color = mix(vec4(254.0/255.0, 254.0/255.0, 172.0/255.0, 1), vec4(254.0/255.0, 197.0/255.0, 21.0/255.0, 1), advance*3);
                    } else if (advance >= 1.0/3 && advance < 2.0/3) {
                        color = mix(vec4(254.0/255.0, 197.0/255.0, 21.0/255.0, 1), vec4(193.0/255.0, 12.0/255.0, 0.0/255.0, 1), advance*3-1);
                    } else {
                        color = mix(vec4(193.0/255.0, 12.0/255.0, 0.0/255.0, 1), vec4(193.0/255.0, 12.0/255.0, 0.0/255.0, 0), advance*3-2);
                    }
                    EmitVertex();
                }
            }

        }
    }
//    EndPrimitive();

}