#version 410

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;
uniform float size;
uniform float alpha;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec4 p3d_ViewMatrix;

// Output to fragment shader
out vec4 color;

void main() {
	gl_Position = p3d_ModelViewProjectionMatrix * p3d_Vertex;
	color.rgb = p3d_Color.rgb;
	color.a = p3d_Color.a * alpha;

	gl_PointSize = size / length((p3d_ModelViewMatrix * p3d_Vertex).xyz);
}
