#version 410
#define HALF_PI radians(90)
#define W 125
#define H 203
#define L 39

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform	float t;  // time

uniform sampler2D flap_tex;
uniform int from_char;
uniform int to_char;

// Reports the frame time of the current frame, for animations.
uniform float osg_FrameTime;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec2 p3d_MultiTexCoord0;

uniform mat4 p3d_ModelViewMatrix;

uniform float size;

// Output to fragment shader
//out vec2 texcoord;
out vec4 color;

void main() {
//	float tile_scale = 1;
//	float simplex_scale = 0.1;
//	float distance = 27;
//	float trans_speed = 0.5;

//	float t = osg_FrameTime;

	color = p3d_Color;

	vec2 tex_size = textureSize(flap_tex, 0);
	vec2 seg_size = vec2(tex_size.x, tex_size.y / L);

	int top_char;
	int bot_char;

	if (t == 0) {
		top_char = from_char;
	} else {
		top_char = to_char;
	}

	if (t < 1) {
		bot_char = from_char;
	} else {
		bot_char = to_char;
	}


	if (p3d_Color.r == 1) {
		color = texture(
			flap_tex,
			vec2(p3d_Vertex.x / W + 0.5, 1 - ((H-p3d_Vertex.z) + H * top_char - H / 2) / tex_size.y )
		);
	}

	if (p3d_Color.g == 1) {
		color = texture(
			flap_tex,
			vec2(p3d_Vertex.x / W + 0.5, 1 - ((H-p3d_Vertex.z) + H * bot_char - H / 2) / tex_size.y )
		);
	}

	vec4 new = p3d_Vertex;

//	float smooth_t = smoothstep(0, 2, t) * 2;
//	float smooth_t = 1 - cos(t * HALF_PI);
	float smooth_t = t;

	if (p3d_Color.b == 1) {
		float angle = (smooth_t * HALF_PI * 2 - HALF_PI);
		new.y = p3d_Vertex.y * cos(angle) - p3d_Vertex.z * sin(angle);
		new.z = p3d_Vertex.y * sin(angle) + p3d_Vertex.z * cos(angle);

		if (t < .5) {
			color = texture(
				flap_tex,
				vec2(p3d_Vertex.x / W + 0.5, 1 - ((p3d_Vertex.y) + H * from_char + H / 2) / tex_size.y )
			);
		} else {
			color = texture(
				flap_tex,
				vec2(p3d_Vertex.x / W + 0.5, 1 - ((H-p3d_Vertex.y) + H * to_char - H / 2) / tex_size.y )
			);
		}

		if (t == 0 || t == 1) {
			color.a = 0.0;
		}

	}

//	vColorVS.rgb = vec3(t);


	gl_Position = p3d_ModelViewProjectionMatrix * new;

	gl_PointSize = size / length((p3d_ModelViewMatrix * new).xyz);
}
