#version 410
#define HALF_PI radians(90)
#define PI radians(180)
#define T .5

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;
uniform float t;
uniform float bottom;
uniform float top;
uniform float size;
uniform float osg_FrameTime;

// Parameters
uniform float simp_start_phi_mul;
uniform float simp_age_mul;
uniform float simp_mul;
uniform float max_r;
uniform float age_mul;
uniform float phi_mul;
uniform float r_mul;
uniform float z_mul;
uniform float z_start_phi_mul;
uniform float z_age_mul;
uniform float z_add;
uniform float phi_inc_mul;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec2 p3d_MultiTexCoord0;

// Output to fragment shader
//out vec2 texcoord;
out vec4 color;

// Notes
// http://www.science-and-fiction.org/rendering/noise.html
// https://shadertoyunofficial.wordpress.com/2019/01/02/programming-tricks-in-shadertoy-glsl/
// https://en.wikipedia.org/wiki/Perlin_noise
// https://en.wikipedia.org/wiki/Simplex_noise
// https://www.shadertoy.com/view/XsX3zB

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

float rand(vec2 co)
{
    return fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453);
}

void main() {
	vec4 new = p3d_Vertex;
	float age;
	float start_phi = atan(p3d_Vertex.x, p3d_Vertex.y);
	float start_r = length(p3d_Vertex.xy);

	// Parameters
//	float simp_start_phi_mul = 1.;
//	float simp_age_mul = 1.;
//	float simp_mul = 5.;
//	float max_r = 3.;
//	float age_mul = 6.;
//	float phi_mul = .5;
//	float r_mul = 2.;
//	float z_mul = .2;
//	float z_start_phi_mul = 1.;
//	float z_age_mul = 1.;
//	float z_add = 1.;
//	float phi_inc_mul = .5;

	float birthday = p3d_Vertex.z;
	birthday += simplex3d(vec3(p3d_Vertex.x * simp_mul, p3d_Vertex.y * simp_mul, 0)) + .3;

	if (t > birthday) {
		age = min((t - birthday) * age_mul, 1);
		age = smoothstep(0, 1, age);
	} else {
		age = 0;
	}

	float phi = mix(start_phi+(rand(vec2(start_phi, start_r))-0.5) * PI * phi_mul, start_phi, age);
	float r = mix(rand(vec2(start_r, start_phi))*max_r, start_r, sin(age*HALF_PI));

	r += simplex3d(vec3(0, start_phi * simp_start_phi_mul, age * simp_age_mul)) * r_mul * sin(age*PI);

	phi += (1 - age) * PI * phi_inc_mul;

	new.x = r * sin(phi);
	new.y = r * cos(phi);

	new.z = mix(bottom, p3d_Vertex.z, 1 - cos(age * HALF_PI));

	new.z += (simplex3d(vec3(0, start_phi * z_start_phi_mul, age * z_age_mul)) + z_add) * z_mul * sin(age * PI);

	color = p3d_Color;
	color.a = mix(color.a*((max_r-r)/max_r), 1, age);

	color.r *= 1 + simplex3d(vec3(new.x + osg_FrameTime*T, new.y + osg_FrameTime*T, new.z + osg_FrameTime*T)) * 0.5;
	color.g *= 1 + simplex3d(vec3(new.z + osg_FrameTime*T, new.x + osg_FrameTime*T, new.y + osg_FrameTime*T)) * 0.5;
	color.b *= 1 + simplex3d(vec3(new.y + osg_FrameTime*T, new.z + osg_FrameTime*T, new.x + osg_FrameTime*T)) * 0.5;

    gl_Position = p3d_ModelViewProjectionMatrix * new;

	gl_PointSize = size / length((p3d_ModelViewMatrix * p3d_Vertex).xyz);
}
