#version 410

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;
uniform float size;
uniform float alpha;
uniform float gray;
uniform float fade;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec4 p3d_ViewMatrix;

// Output to fragment shader
out vec4 color;

void main() {
	gl_Position = p3d_ModelViewProjectionMatrix * p3d_Vertex;
	color = p3d_Color;
	if (p3d_Color.rgb == vec3(1, 1, 1)) {
		color.rgb = vec3(255.0/255.0, 208.0/255.0, 194.0/255.0);
	} else {
		color.rgb = vec3(153.0/255.0, 17.0/255.0, 1.0/255.0);
	}
	color.a = alpha;

	if (gray > 0) {
		float lum = dot(vec3(0.299, 0.587, 0.114), color.rgb);
		color.rgb = mix(color.rgb, vec3(lum), gray);
	}

	if (fade < 1) {
        color.rgb *= fade;
    }


	gl_PointSize = size / length((p3d_ModelViewMatrix * p3d_Vertex).xyz);
}
