#version 410

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;
uniform float size;
uniform sampler2D scroll_tex;
uniform float progress;
uniform float gray;
//uniform float fade;

// Reports the frame time of the current frame, for animations.
uniform float osg_FrameTime;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec4 p3d_ViewMatrix;

// Output to fragment shader
out vec4 color;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

void main() {
//	color = p3d_Color;
	vec4 position;

	if (p3d_Vertex.x > 12.5 || p3d_Vertex.x < -12.5 || p3d_Vertex.y > 15 || p3d_Vertex.y < -15) {
		color.a = 0;
		position = p3d_Vertex;
	} else {
//		vec4 probe = texture(scroll_tex, vec2((p3d_Vertex.x+12.5)/25, -(p3d_Vertex.y+15.0)/25-osg_FrameTime*0.1));
//		color = probe;
//		vec4 probe = texture(scroll_tex, vec2((p3d_Vertex.x+12.5)/25, -(p3d_Vertex.y+15.0)/25-osg_FrameTime*0.1));
		vec2 size = textureSize(scroll_tex, 0);
		color.a = texture(scroll_tex, vec2((p3d_Vertex.x+12.5)/25, -(p3d_Vertex.y+15.0)/25*size.x/size.y-progress)).a;
		if (color.a > 0) {
			float z = simplex3d(vec3(p3d_Vertex.x*0.1, p3d_Vertex.y*0.1, osg_FrameTime));
			float z_diff = simplex3d(vec3((p3d_Vertex.x+0.1)*0.1, p3d_Vertex.y*0.1, osg_FrameTime));
			float factor = 0.5+(z_diff-z)*20;
	//		factor = smoothstep(0, 1, factor);
	//		color.rgb = vec3(factor);
			color.rgb = mix(vec3(153.0/255.0, 17.0/255.0, 1.0/255.0), vec3(255.0/255.0, 208.0/255.0, 194.0/255.0), factor);
//			color.rgb *= (p3d_Vertex.y+15.0)/25;
			position.xyw = p3d_Vertex.xyw;
			position.z = p3d_Vertex.z + z;
		}
	}

	if (gray > 0) {
		float lum = dot(vec3(0.299, 0.587, 0.114), color.rgb);
		color.rgb = mix(color.rgb, vec3(lum), gray);
	}

	gl_Position = p3d_ModelViewProjectionMatrix * position;
	gl_PointSize = size / length((p3d_ModelViewMatrix * position).xyz);
}
