#version 410
#define STRIPES 16
#define PI radians(180)

uniform sampler2D tex1;
uniform sampler2D tex2;
uniform int bloom_radius;
uniform int blur_radius;
uniform float strength;
uniform float fade;

uniform float osg_FrameTime;
uniform vec2 light_ball_frag;
uniform bool enable_light;
uniform float sanity;

uniform float neon;
uniform float mag;

// Input from vertex shader
//in vec2 texcoord;

// Output to the screen
out vec4 p3d_FragColor;

float weight(float t, float log2radius, float gamma)
{
    return exp(-gamma*pow(log2radius-t,2.));
}

vec4 sample_bloomed(vec2 uv, float radius, float gamma, vec2 my_t_size)
{
    vec4 pix = vec4(0.);
    float norm = 0.;
    //weighted integration over mipmap levels
    for(float i = 0.0; i < 10.0; i += 0.5)
//    for(int i = 0; i < 10; i += 1)
    {
        float k = weight(i, log2(radius), gamma);
        vec4 dupa = k*texture(tex2, uv, i);

//        if (enable_light == true) {
//            vec2 light_uv = light_ball_frag / 2 + 0.5;
//            dupa += vec4(227/255., 222/255., 219/255., 1) / (length( vec2(uv.x - light_uv.x, (uv.y - light_uv.y) * my_t_size.y / my_t_size.x) ) * 40) * neon * mag;
//        }

        pix += dupa;
        norm += k;
    }
    //nomalize, and a bit of brigtness hacking
    return pix*pow(norm,-0.95);
}

vec4 sample_blured(vec2 uv, float radius, float gamma, vec2 my_t_size)
{
    vec4 pix = vec4(0.);
    float norm = 0.;
    //weighted integration over mipmap levels
    for(float i = 0.0; i < 10.0; i += 0.5)
//    for(int i = 0; i < 10; i += 1)
    {
        float k = weight(i, log2(radius), gamma);
        vec4 dupa = k*texture(tex1, uv, i);

//        if (enable_light == true) {
//            vec2 light_uv = light_ball_frag / 2 + 0.5;
//            dupa += vec4(227/255., 222/255., 219/255., 1) / (length( vec2(uv.x - light_uv.x, (uv.y - light_uv.y) * my_t_size.y / my_t_size.x) ) * 40) * neon * mag;
//        }

        pix += dupa;
        norm += k;
    }
    //nomalize, and a bit of brigtness hacking
    return pix*pow(norm,-0.95);
}


void main() {
//    float blur_radius = 10;  // max 51

    vec2 t_size = textureSize(tex2, 0);

    vec2 uv = gl_FragCoord.xy / t_size;

//    if (gl_FragCoord.y >= 50 && gl_FragCoord.x >= 50 && gl_FragCoord.y <= t_size.y - 50 && gl_FragCoord.x <= t_size.x - 50) {
    if (true) {

        float age = min(2, sanity*3.5-max(0.0, int((1-uv.x)*STRIPES)*0.1)) * PI;

        if (age > 0 && sanity < 1) {
            float in_stripe_pos = fract(uv.x*STRIPES);
            if (abs(in_stripe_pos-0.5)*2 <= abs(sin(age))) {
                p3d_FragColor = vec4(abs(sin(age)), abs(sin(age)), abs(sin(age)*2), 1);
    //            vec4 stripe = vec4(abs(sin(age)), abs(sin(age)), abs(sin(age)*2), 1);
    //            vec4 color = texture(tex1, uv);
    //            color = mix(color, stripe, sin(age));
    //            vec4 bloom = sample_blured(uv, blur_radius, 0.5, t_size);
    //            p3d_FragColor = color + bloom * strength;
            } else {
                vec4 color = texture(tex1, uv);
                vec4 bloom = sample_bloomed(uv, bloom_radius, 0.5, t_size);
                p3d_FragColor = color + bloom * strength;
            }
        } else {
            vec4 color;
            if (blur_radius == 0) {
                color = texture(tex1, uv);
            } else {
                color = sample_blured(uv, blur_radius, 0.5, t_size);
            }
            vec4 bloom = sample_bloomed(uv, bloom_radius, 0.5, t_size);
            p3d_FragColor = color + bloom * strength;

            p3d_FragColor *= fade;

            if (enable_light == true) {
                vec2 light_uv = light_ball_frag / 2 + 0.5;
                p3d_FragColor += vec4(227/255., 222/255., 219/255., 1) / (length( vec2(uv.x - light_uv.x, (uv.y - light_uv.y) * t_size.y / t_size.x) ) * 40) * neon * mag;
            }

            float fact_x = min(smoothstep(0, 40, gl_FragCoord.x), smoothstep(t_size.x, t_size.x - 40, gl_FragCoord.x));
            float fact_y = min(smoothstep(0, 40, gl_FragCoord.y), smoothstep(t_size.y, t_size.y - 40, gl_FragCoord.y));
            p3d_FragColor *= fact_x * fact_y;

        }

    } else {
        discard;
    }

}
