#version 410
#define FREQ 50
#define TWO_PI radians(360)
#define Z_MUL 10.0
#define T_MUL 0.5
#define S_MUL 2.0

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;
uniform float size;
uniform float magn;
uniform float fade;
uniform float amp;
uniform float osg_FrameTime;
uniform float freak;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec4 p3d_ViewMatrix;

// Output to fragment shader
out vec4 color;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

float rand(vec2 co){
  return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

mat2 get_mat(float my_a) {
	float s = sin(my_a);
	float c = cos(my_a);
	mat2 m = mat2(c, s, -s, c);
	return m;
}

void main() {
	vec4 position;
	position.w = p3d_Vertex.w;

	vec3 line_x = vec3(p3d_Vertex.x, round(p3d_Vertex.y * FREQ) / FREQ, round(p3d_Vertex.z * FREQ) / FREQ);
	vec3 line_y = vec3(round(p3d_Vertex.x * FREQ) / FREQ, p3d_Vertex.y, round(p3d_Vertex.z * FREQ) / FREQ);
	vec3 line_z = vec3(round(p3d_Vertex.x * FREQ) / FREQ, round(p3d_Vertex.y * FREQ) / FREQ, p3d_Vertex.z);

	vec3 len = vec3(length(p3d_Vertex.rgb-line_x), length(p3d_Vertex.rgb-line_y), length(p3d_Vertex.rgb-line_z));
	float min_len = min(min(len.x, len.y), len.z);

//	float amp = 1;
//	float amp = sin(osg_FrameTime) * 0.5 + 0.5;
//	amp = 0;

//		float a = -osg_FrameTime * TWO_PI / 11.077 + simplex3d(vec3(position.z * Z_MUL, osg_FrameTime * T_MUL, 0)) * S_MUL * freak;
//		float a = -osg_FrameTime * TWO_PI / 11.077 + simplex3d(vec3(position.z * Z_MUL, osg_FrameTime * T_MUL, 0)) * S_MUL;

//		float a = osg_FrameTime;

//	float a = freak * TWO_PI;
//	float s = sin(a);
//	float c = cos(a);
//	mat2 m = mat2(c, s, -s, c);

//	float freak = 0;

//	mat2 rot_mat = get_mat(freak * TWO_PI);

	if (min_len == len.x) {
		position.xyz = mix(p3d_Vertex.xyz, line_x, magn);

		float wiatrak = round(rand(position.yz) * 5) - 2.5;
		if (wiatrak > 0) {
			wiatrak += 0.5;
		} else {
			wiatrak -= 0.5;
		}
		mat2 rot_mat = get_mat(freak * TWO_PI * wiatrak);
		float mid = (floor(position.x * FREQ) / FREQ + ceil(position.x * FREQ) / FREQ) / 2;
		position.xz = vec2(mid, position.z) + rot_mat * vec2(position.x - mid, 0);

		vec3 copy = position.xyz;
		position.y += simplex3d(vec3(copy.z, position.x * 100, osg_FrameTime * 5)) * 0.03 * amp;
		position.z += simplex3d(vec3(copy.y, osg_FrameTime * 5, position.x * 100)) * 0.03 * amp;
	} else if (min_len == len.z) {
		position.xyz = mix(p3d_Vertex.xyz, line_z, magn);

		float wiatrak = round(rand(position.xy) * 5) - 2.5;
		if (wiatrak > 0) {
			wiatrak += 0.5;
		} else {
			wiatrak -= 0.5;
		}
		mat2 rot_mat = get_mat(freak * TWO_PI * wiatrak);
		float mid = (floor(position.z * FREQ) / FREQ + ceil(position.z * FREQ) / FREQ) / 2;
		position.zy = vec2(mid, position.y) + rot_mat * vec2(position.z - mid, 0);

		vec3 copy = position.xyz;
		position.x += simplex3d(vec3(copy.y, position.z * 100, osg_FrameTime * 5)) * 0.03 * amp;
		position.y += simplex3d(vec3(copy.x, osg_FrameTime * 5, position.z * 100)) * 0.03 * amp;
	} else {
		position.xyz = mix(p3d_Vertex.xyz, line_y, magn);

		float wiatrak = round(rand(position.xz) * 5) - 2.5;
		if (wiatrak > 0) {
			wiatrak += 0.5;
		} else {
			wiatrak -= 0.5;
		}
		mat2 rot_mat = get_mat(freak * TWO_PI * wiatrak);
		float mid = (floor(position.y * FREQ) / FREQ + ceil(position.y * FREQ) / FREQ) / 2;
		position.yx = vec2(mid, position.x) + rot_mat * vec2(position.y - mid, 0);

		vec3 copy = position.xyz;
		position.x += simplex3d(vec3(copy.z, position.y * 100, osg_FrameTime * 5)) * 0.03 * amp;
		position.z += simplex3d(vec3(copy.x, osg_FrameTime * 5, position.y * 100)) * 0.03 * amp;
	}

	gl_Position = p3d_ModelViewProjectionMatrix * position;
	color.rgb = p3d_Color.rgb;
	color.a = fade;

	color.rgb *= (magn + 1.);

	gl_PointSize = size / length((p3d_ModelViewMatrix * position).xyz);
}
