#version 410
#define HALF_PI radians(90)
#define PI radians(180)
#define MICRO_FREQ 10
#define MICRO_AMP 0.5
//#define POWER 12
//#define MICRO_FREQ 10
//#define MICRO_AMP 0.0

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform mat4 p3d_ModelViewMatrix;
uniform float size;
uniform float osg_FrameTime;
uniform float p;  // power
uniform float scale;
uniform float lvl;
uniform float storm;
uniform float rot;
uniform float hi;
uniform float drop;
uniform int power;
uniform float fade;


// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec4 p3d_ViewMatrix;

// Output to fragment shader
out vec4 color;

float hash(float p){
    return fract(4768.1232345456 * sin(p));
}

float wave(vec4 uv, vec4 emitter, float speed, float phase, float timeshift){
    float dst = distance(uv, emitter);
    return exp(sin(dst * phase - timeshift * speed) - 1.0);
}
vec4 wavedrag(vec4 uv, vec4 emitter){
    return normalize(uv - emitter);
}
float seedWaves = 0.0;
vec4 randWaves(){
    float x = hash(seedWaves);
    seedWaves += 1.0;
    float y = hash(seedWaves);
    seedWaves += 1.0;
    float z = hash(seedWaves);
    seedWaves += 1.0;
    float w = hash(seedWaves);
    seedWaves += 1.0;
    return vec4(x,y,z,w) * 2.0 - 1.0;
}

float getwaves5d(vec4 position, float dragmult, float timeshift){
    float iter = 0.0;
    float phase = 6.0;
    float speed = 2.0;
    float weight = 1.0;
    float w = 0.0;
    float ws = 0.0;
    for(int i=0;i<20;i++){
        vec4 p = randWaves() * 30.0;
        float res = wave(position, p, speed, phase, 0.0 + timeshift);
        float res2 = wave(position, p, speed, phase, 0.006 + timeshift);
        position -= wavedrag(position, p) * (res - res2) * weight * dragmult;
        w += res * weight;
        iter += 12.0;
        ws += weight;
        weight = mix(weight, 0.0, 0.2);
        phase *= 1.2;
        speed *= 1.02;
    }
    return w / ws;
}

float wave_h(float my_x, float my_y, float my_t) {
	vec2 uv = vec2((my_x+10)/20, (my_y+10)/20);
	float water_h = getwaves5d(vec4(my_x*0.15, my_y*0.15, 0, 0.0), 15.0, my_t) * storm;
	return water_h;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

//const float PI = 3.1415926535897932384626433832795028841971693993751058209749;

float getPhi(in float y, in float x)
{
    float ret;
    if (x == 0.0) {
        if (y == 0.0) {
            ret = 0.0;
        } else if (y > 0.0) {
            ret = PI/2.0;
        } else {
            ret = -1.0 * PI/2.0;
        }
    } else if (x > 0.0) {
        ret = atan(y/x);
    } else if (x < 0.0) {
        if (y >= 0.0) {
            ret = atan(y/x) + PI;
        } else {
            ret = atan(y/x) + PI;
        }
    }
    return ret;
}

vec3 toPolar(in vec3 cart)
{
    float xySquared = (cart.x * cart.x) + (cart.y * cart.y);
    float radius = sqrt(xySquared + (cart.z * cart.z));
    return vec3(radius, atan(sqrt(xySquared), cart.z), getPhi(cart.y, cart.x));
}

vec3 toCartesian(in vec3 sph) {
    return vec3(
        sin(sph.y) * cos(sph.z) * sph.x,
        sin(sph.y) * sin(sph.z) * sph.x,
        cos(sph.y) * sph.x
    );
}

void main() {

	vec4 position = p3d_Vertex;

    float phi = atan(position.x, position.y) + rot;
	float r = length(position.xy);
    position.x = r * cos(phi);
	position.y = r * sin(phi);

//    float new_hi = hi + simplex3d(vec3(position.x, position.y, osg_FrameTime)) * drop;
//    float new_hi = hi + wave_h(position.x * 2, position.y * 2, osg_FrameTime) * 10 * drop;
    float new_hi = hi;

    position.z += new_hi;

    float wave = wave_h(position.x, position.y, osg_FrameTime);
    seedWaves = 0.0;
    float diff = wave_h(position.x+0.02*20, position.y+0.02*20, osg_FrameTime);
    float diff_len = (diff - wave)*5+0.5;
    wave *= 5;
    float elev = wave;

    float morph = smoothstep(0, 9, position.z);

    float lum = dot(vec3(0.299, 0.587, 0.114), p3d_Color.rgb);
    vec4 color_r = vec4(lum*233.0/255.0, lum*231.0/255.0, lum*229.0/255.0, p3d_Color.a);
    color = vec4(vec3(55/255./2., 88/255./2., 114/255./2.) * diff_len*2, 1);
//    color = vec4(vec3(222/255./2., 244/255./2., 252/255./2.) * diff_len*2, 1);
//    color = vec4(vec3(35/255./2., 137/255./2., 218/255./2.) * diff_len*2, 1);
//    color = vec4(vec3(15/255./2., 94/255./2., 156/255./2.) * diff_len*2, 1);
    color = mix(color, vec4(102/255., 142/255., 167/255., 1.0), smoothstep(1.1, 1.5, elev));
    color = mix(color, color_r, morph);

    position.z += mix(wave, 0, morph);

//    position.z += drop;

//    position.z += simplex3d(vec3(position.x, position.y, osg_FrameTime));

    if (position.z < wave) {
        position.z = wave;
    }

//    color.rgb += drop;
//    float burn = smoothstep(-1, +1, simplex3d(vec3(toPolar(position.xyz).yz, osg_FrameTime)) + drop);
//    vec3 polar = toPolar(position.xyz));
//    float burn = smoothstep(-1, +1, simplex3d(vec3(polar[1] * 5, polar[2] * 2, 0)) + drop);
    float burn = smoothstep(-1, +1, simplex3d(position.xyz) + drop);
    color.rgb = mix(color.rgb, vec3(55/255./2., 88/255./2., 114/255./2.), burn);
    if (burn == 1) {
        color.a = 0.0;
    }
//    color.a = smoothstep(1.0, 0.0, burn);
    color.rgb *= fade;

    float expl = 1 + smoothstep(0.0, 1.0, burn) * .05;
    position.x *= pow(expl, power);
    position.y *= pow(expl, power);
    position.z = position.z + (position.z - 120) * (expl - 1);

    position += simplex3d(p3d_Vertex.xyz * MICRO_FREQ) * burn * MICRO_AMP;

//    position.z = max(position.z, wave);

//    position.xyz = position.xyz * (1 + drop * simplex3d(toPolar(position.xyz)/5));

	gl_Position = p3d_ModelViewProjectionMatrix * position;

	gl_PointSize = size / length((p3d_ModelViewMatrix * position).xyz);
}
