#version 410

uniform sampler2D p3d_Texture0;
uniform float osg_FrameTime;
uniform bool decrunch;
uniform float fade;

// Input from vertex shader
in vec2 texcoord;

// Output to the screen
out vec4 p3d_FragColor;

void main() {
    vec4 color = texture(p3d_Texture0, texcoord);
//    p3d_FragColor = color.bgra;
    p3d_FragColor = color;

    if (texcoord.x < .2 || texcoord.x > .8 || texcoord.y < .03 || texcoord.y > .97) {
        p3d_FragColor.rgb = vec3(0);
    }

    if (decrunch == true && p3d_FragColor.a == 0) {
        p3d_FragColor.r = mod(2., sin(0.9e3 / texcoord.y * osg_FrameTime));
        p3d_FragColor.g = mod(2., sin(1.0e3 / texcoord.y * osg_FrameTime));
        p3d_FragColor.b = mod(2., cos(1.1e3 / texcoord.y * osg_FrameTime));
        p3d_FragColor.a = 1;
    }

    p3d_FragColor.a *= fade;
}
