#version 410

// Uniform inputs
uniform sampler2D p3d_Texture0;
uniform float gray;
uniform float fade;

// Input from vertex shader
in vec2 texcoord;

// Output to the screen
out vec4 p3d_FragColor;

void main() {
    p3d_FragColor = texture(p3d_Texture0, texcoord);

    if (gray > 0) {
        p3d_FragColor = texture(p3d_Texture0, texcoord);
		float lum = dot(vec3(0.299, 0.587, 0.114), p3d_FragColor.rgb);
		p3d_FragColor.rgb = mix(p3d_FragColor.rgb, vec3(lum), gray);
	} else {
        p3d_FragColor = texture(p3d_Texture0, texcoord);
    }

    if (fade != 1) {
        p3d_FragColor.rgb *= fade;
    }
}
