#version 410
#define HALF_PI radians(90)
#define PI radians(180)
#define USE_IQ_SMIN 0

// Uniform inputs

// This is probably the most important uniform, transforming a model-space
// coordinate into a clip-space (ie. relative to the window) coordinate.  This
// is usually used in the vertex shader to transform p3d_Vertex and store the
// result in gl_Position.
uniform mat4 p3d_ModelViewProjectionMatrix;

// These are parts of the above matrix.
uniform mat4 p3d_ModelViewMatrix;
uniform mat4 p3d_ProjectionMatrix;
uniform mat4 p3d_ModelMatrix;
uniform mat4 p3d_ViewMatrix;
uniform mat4 p3d_ViewProjectionMatrix;

// Reports the frame time of the current frame, for animations.
uniform float osg_FrameTime;
float iTime = osg_FrameTime;
//uniform sampler2D face_tex;
uniform float pt;
uniform float pos;
uniform float storm;
uniform float size;
uniform float head;
uniform sampler2D enigma_tex;
uniform sampler2D desert_tex;
uniform sampler2D state_tex;
uniform sampler2D second_tex;
uniform sampler2D window_tex;
uniform sampler2D megademo_tex;
uniform sampler2D lifeforce_tex;
uniform sampler2D ziphead_tex;
uniform sampler2D credits_tex;
uniform int demo;
uniform float window_z;
uniform float color_magn;
uniform float max_r;
uniform float cred_shift;
uniform float line;
uniform bool reflection;
uniform float moon;
uniform float dark;
uniform float gray;
uniform float fade;
uniform bool show;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec2 p3d_MultiTexCoord0;

// Output to fragment shader
out vec4 color;

float time;

vec2 leg0[3];
vec2 leg1[3];

vec2 arm0[3];
vec2 arm1[3];

float wlen=15.0;
float bob;
float wc_scale=0.5;
float scroll;
float scene_scale=15.0;

// Finds the entry and exit points of a 2D ray with a circle of radius 1
// centered at the origin.
vec2 intersectCircle(vec2 ro, vec2 rd)
{
	float a = dot(rd, rd);
	float b = 2.0 * dot(rd, ro);
	float ds = b * b - 4.0 * a * (dot(ro, ro) - 1.0);

	if(ds < 0.0)
		return vec2(1e3);

	return ((-b - sqrt(ds) * vec2(-1.0, 1.0))) / (2.0 * a);
}

mat3 rotateXMat(float a)
{
	return mat3(1.0, 0.0, 0.0, 0.0, cos(a), -sin(a), 0.0, sin(a), cos(a));
}

mat3 rotateYMat(float a)
{
	return mat3(cos(a), 0.0, -sin(a), 0.0, 1.0, 0.0, sin(a), 0.0, cos(a));
}

// Adapted from https://www.shadertoy.com/view/ldlGR7
vec2 solve( vec2 p, float l1, float l2, float side )
{
	vec2 q = p*( 0.5 + 0.5*(l1*l1-l2*l2)/dot(p,p) );

	float s = l1*l1/dot(q,q) - 1.0;

	if( s<0.0 ) return vec2(-100.0);

	return q + q.yx*vec2(-1.0,1.0)*side*sqrt( s );
}

// Returns a pyramid-like periodic signal.
float pyramid(float x)
{
	x = fract(x);
	return min(x * 2.0, (1.0 - x) * 2.0);
}

// Returns a semicircular periodic signal.
float circ(float x)
{
	x = fract(x) * 2.0 - 1.0;
	return sqrt(1.0 - x * x);
}

#if USE_IQ_SMIN
float smin(float a,float b,float k){ return -log(exp(-k*a)+exp(-k*b))/k;}//from iq
#else
// http://www.johndcook.com/blog/2010/01/20/how-to-compute-the-soft-maximum/
float smin(in float a, in float b, in float k) { return a - log(1.0+exp(k*(a-b))) / k; }
#endif

float mp(float x)
{
	float y=0.3;
	return clamp((pyramid(x)-0.5)*2.0-0.4,-y,y);
}

float mosaic(vec3 p)
{
	// Disabled because it causes a compilation failure due to time-out or size limit.
	return 0.0;//max(mp(p.y*10.0),mp(p.z*10.0))*0.01;
}
/*
mat3 transpose(mat3 m)
{
	return mat3(vec3(m[0].x,m[1].x,m[2].x),
				vec3(m[0].y,m[1].y,m[2].y),
				vec3(m[0].z,m[1].z,m[2].z));
}*/

float capsuleDist(vec3 p,vec3 o,vec3 d,float h0,float h1,float r0,float r1)
{
	vec3 u=cross(d,vec3(1.0,0.0,0.0));
	vec3 v=cross(u,d);
	u=cross(v,d);
	mat3 m=transpose(mat3(normalize(u),normalize(v),normalize(d)));
	d=normalize(d);
	float t=clamp(dot(p-o,d),h0,h1);
	vec3 np=o+t*d;
	return distance(np,p)-mix(r0,r1,t)+mosaic(m*(p-o));
}

float boxDist(vec3 p,vec3 s,float r)
{
	return length(max(vec3(0.0),abs(p)-s))-r+mosaic(p);
}

float sphereDist(vec3 p,vec3 o,float r)
{
	return distance(p,o)-r+mosaic(p-o);
}

float sceneDist(vec3 p)
{
	float d=1e3;

	p+=vec3(0.0,0.07,0.0)*scene_scale;
	p=rotateYMat(3.1415926*0.5)*p;

	p.z+=cos(p.y*2.0+time)*0.1;
	float tm=fract(time*wc_scale*2.0-0.1);
	p.x-=(smoothstep(0.0,0.3,tm)-smoothstep(0.4,1.0,tm))*smoothstep(0.5,2.0,p.y)*0.2+scroll;

	// Leg 0
	{
		float g=0.08;
		vec3 o=vec3(0.0,0.0,0.2);
		float d0=capsuleDist(p+o,vec3(leg0[0],0.0),vec3(leg0[1]-leg0[0],0.0),0.0,1.0-g,0.1,0.1);
		float d1=capsuleDist(p+o,vec3(leg0[1],0.0),vec3(leg0[2]-leg0[1],0.0),g,1.0,0.1,0.2);
		d=min(d,smin(d0,d1,15.0));
	}

	// Leg 1
	{
		float g=0.08;
		vec3 o=vec3(0.0,0.0,-0.2);
		float d0=capsuleDist(p+o,vec3(leg1[0],0.0),vec3(leg1[1]-leg1[0],0.0),0.0,1.0-g,0.1,0.1);
		float d1=capsuleDist(p+o,vec3(leg1[1],0.0),vec3(leg1[2]-leg1[1],0.0),g,1.0,0.1,0.2);
		d=min(d,smin(d0,d1,15.0));
	}

	p.y-=bob;

	// Arm 0
	{
		float g=0.08;
		vec3 o=vec3(0.0,0.0,0.4);
		mat3 m=rotateXMat(-0.3)*rotateYMat((cos((time*wc_scale+0.5)*3.1415926*2.0)-0.6)*0.5);
		float d0=capsuleDist(p+o,vec3(arm0[0],0.0),m*vec3(arm0[1]-arm0[0],0.0),0.0,0.7-g,0.03,0.03);
		float d1=capsuleDist(p+o,vec3(arm0[0],0.0)+m*vec3(arm0[1]-arm0[0],0.0),m*vec3(arm0[2]-arm0[1],0.0),g,0.7,0.03,0.06);
		d=min(d,smin(d0,d1,15.0));
	}

	// Arm 1
	{
		float g=0.08;
		vec3 o=vec3(0.0,0.0,-0.4);
		mat3 m=rotateXMat(0.3)*rotateYMat(-(cos(time*wc_scale*3.1415926*2.0)-0.6)*0.5);
		float d0=capsuleDist(p+o,vec3(arm1[0],0.0),m*vec3(arm1[1]-arm1[0],0.0),0.0,0.7-g,0.03,0.03);
		float d1=capsuleDist(p+o,vec3(arm1[0],0.0)+m*vec3(arm1[1]-arm1[0],0.0),m*vec3(arm1[2]-arm1[1],0.0),g,0.7,0.03,0.06);
		d=min(d,smin(d0,d1,15.0));
	}

	// Torso
	d=smin(d,boxDist(p+vec3(0.0,-0.7,0.0),vec3(0.05,0.7,0.15),0.1),15.0);
	d=smin(d,boxDist(p+vec3(-0.1,-1.1,0.0),vec3(0.05,0.2,0.15)*0.1,0.1),5.0);

	// Head
	d=smin(d,sphereDist(p,vec3(0.0,1.825,0.0),0.2),15.0);


	return d;
}

vec3 sceneNorm(vec3 p)
{
	p*=scene_scale;
	float c=sceneDist(p);
	float e=1e-3;
	return normalize(vec3(sceneDist(p+vec3(e,0,0))-c,
						  sceneDist(p+vec3(0,e,0))-c,
						  sceneDist(p+vec3(0,0,e))-c));
}

float robot(vec3 ro,vec3 rd)
{
	float t=0.0;
	float tm;

	tm=time*wc_scale;

	leg0[0]=vec2(0.0,bob);
	leg0[2]=vec2(pyramid(tm)-0.3,-1.8+0.3*circ(tm*2.0)*step(fract(tm),0.5));
	leg0[1]=(leg0[0]+solve(leg0[2]-leg0[0],1.0,1.0,1.0));

	arm1[0]=vec2(0.0,1.4);
	arm1[2]=vec2(pyramid(tm)-0.3,0.1+pow(pyramid(tm),2.0)*0.7);
	arm1[1]=(arm1[0]+solve(arm1[2]-arm1[0],0.7,0.7,-1.0));

	tm+=0.5;

	leg1[0]=vec2(0.0,bob);
	leg1[2]=vec2(pyramid(tm)-0.3,-1.8+0.3*circ(tm*2.0)*step(fract(tm),0.5));
	leg1[1]=(leg1[0]+solve(leg1[2]-leg1[0],1.0,1.0,1.0));

	arm0[0]=vec2(0.0,1.4);
	arm0[2]=vec2(pyramid(tm)-0.3,0.1+pow(pyramid(tm),2.0)*0.7);
	arm0[1]=(arm0[0]+solve(arm0[2]-arm0[0],0.7,0.7,-1.0));

	float rt=1e4;

	ro*=scene_scale;
	rd*=scene_scale;

	for(int i=0;i<15;i+=1)
	{
		vec3 rp=ro+rd*t;

		float d=sceneDist(rp);

		if(d<1e-2)
		{
			rt=t;
		}

		t+=d/scene_scale;
	}


	return rt;
}


vec2 unitSquareInterval(vec2 ro, vec2 rd)
{
	vec2 slabs0 = (vec2(+1.0) - ro) / rd;
	vec2 slabs1 = (vec2(-1.0) - ro) / rd;

	vec2 mins = min(slabs0, slabs1);
	vec2 maxs = max(slabs0, slabs1);

	return vec2(max(mins.x, mins.y),
				min(maxs.x, maxs.y));
}

vec3 squaresColours(vec2 p)
{
	p+=vec2(time*0.2);

	vec3 orange=vec3(1.0,0.4,0.1)*2.0;
	vec3 purple=vec3(1.0,0.2,0.5)*0.8;

	float l=pow(0.5+0.5*cos(p.x*7.0+cos(p.y)*8.0)*sin(p.y*2.0),4.0)*2.0;
	vec3 c=pow(l*(mix(orange,purple,0.5+0.5*cos(p.x*40.0+sin(p.y*10.0)*3.0))+
				  mix(orange,purple,0.5+0.5*cos(p.x*20.0+sin(p.y*3.0)*3.0))),vec3(1.2))*0.7;

	c+=vec3(1.0,0.8,0.4)*pow(0.5+0.5*cos(p.x*20.0)*sin(p.y*12.0),20.0)*2.0;

	c+=vec3(0.1,0.5+0.5*cos(p*20.0))*vec3(0.05,0.1,0.4).bgr*0.7;

	return c;
}

vec3 squaresTex(vec2 p,float border)
{
	float sm=0.02;
	vec2 res=vec2(8.0);
	vec2 ip=floor(p*res)/res;
	vec2 fp=fract(p*res);
	float m=1.0-max(smoothstep(border-sm,border,abs(fp.x-0.5)),smoothstep(border-sm,border,abs(fp.y-0.5)));
	m+=1.0-smoothstep(0.0,0.56,distance(fp,vec2(0.5)));
	return m*squaresColours(ip);
}

vec3 room(vec3 ro,vec3 rd,out vec3 rp,out vec3 n)
{
	vec2 box_size=vec2(1.0,5.0+3.0/8.0);

	vec2 cp=vec2(0.0),ct=vec2(1e3);

	for(int i=0;i<4;i+=1)
	{
		float cr=0.03;
		vec2 tcp=vec2(2.5/8.0*float(-1),float(i)-2.0+0.5/8.0);
		vec2 tct=intersectCircle((ro.xz-tcp)/cr,rd.xz/cr);

		if(tct.y > 0.0 && tct.y<ct.y)
		{
			ct=tct;
			cp=tcp;
		}
	}

	for(int i=0;i<4;i+=1)
	{
		float cr=0.03;
		vec2 tcp=vec2(2.5/8.0*float(+1),float(i)-2.0+0.5/8.0);
		vec2 tct=intersectCircle((ro.xz-tcp)/cr,rd.xz/cr);

		if(tct.y > 0.0 && tct.y<ct.y)
		{
			ct=tct;
			cp=tcp;
		}
	}

	ct.y=max(0.0,ct.y);

	vec3 ci=ro+rd*ct.y;
	vec2 cu=vec2(atan(ci.z-cp.y,ci.x-cp.x)/3.1415926*0.5,(ci.y+0.5/8.0)*4.0);

	float wt=max(0.0,unitSquareInterval(ro.xy * box_size, rd.xy * box_size).y);
	float t=min(ct.y,wt);

	rp=ro+rd*(t-1e-4);

	n.z=0.0;
	if(abs(rp.x*box_size.x)>abs(rp.y*box_size.y))
		n.xy=vec2(rp.x/abs(rp.x),0.0);
	else
		n.xy=vec2(0.0,rp.y/abs(rp.y));

	if(ct.y<wt)
	{
		n.y=0.0;
		n.xz=normalize(rp.xz-ci.xz);
	}

	float l=1.0-smoothstep(0.0,3.0,abs(rp.z-ro.z));

	vec3 wc=mix(squaresTex(rp.zy+vec2(0.0,0.5/8.0),0.5),squaresTex(rp.xz,0.44),step(0.999/box_size.y,abs(rp.y)));
	vec3 cc=squaresTex(cu,0.45)+0.8*vec3(smoothstep(0.83/5.0,0.86/5.0,abs(rp.y)));

	return l*mix(cc,wc,step(wt,t));
}

vec3 scene(vec2 p)
{
	mat3 cam = rotateXMat(cos(time * 0.2) * 0.1) * rotateYMat(time * 0.5);
	float lt=mod(time*wc_scale,wlen)/wlen;

	vec3 ro = cam*vec3(0.0,-0.15+lt*0.15, 0.15+lt*0.2)+vec3(0.0,0.0,scroll/scene_scale);
	vec3 rd = cam*vec3(p, -1.0);

	rd=normalize(rd);

	float robot_t=robot(ro,rd);

	vec3 n,rp;

	vec3 c;
	vec3 c0=room(ro,rd,rp,n);

	if(robot_t < distance(ro,rp))
	{
		rp=ro+rd*robot_t;
		n=sceneNorm(rp);
		vec3 r=reflect(rd,n);
		c=vec3(0.5+0.5*n.y)*0.5*vec3(1.0,0.8,0.5);
		vec3 c1=room(rp,r,rp,n);
		c+=c1*0.5;
	}
	else
	{
		vec3 r=reflect(rd,n);
		vec3 c1=room(rp,r,rp,n);
		c=c0+c1*c0*0.4;
	}

	vec3 ll=vec3(1.0-(smoothstep(0.0,0.07,lt)-smoothstep(0.93,1.0,lt)));

	return ll+c+
		0.6*((sin(p.y)*cos(p.x+time*2.0)*0.5+0.5)*
			 pow(mix(vec3(1.0,0.7,0.1),vec3(1.0,0.2,0.6),0.5+0.5*cos(p.x+sin(time*3.0+p.y*2.0))),vec3(2.0)));
}

// Notes
// http://www.science-and-fiction.org/rendering/noise.html
// https://shadertoyunofficial.wordpress.com/2019/01/02/programming-tricks-in-shadertoy-glsl/
// https://en.wikipedia.org/wiki/Perlin_noise
// https://en.wikipedia.org/wiki/Simplex_noise
// https://www.shadertoy.com/view/XsX3zB

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

vec2 simp_h(float my_x, float my_y, float my_z) {
	float my_h = simplex3d(vec3(my_x*0.2, my_y*0.2, my_z*.1));
//	return my_h;
//	return vec2(simplex3d(vec3(my_x*0.2, my_y*0.2, my_z*.1)), 0);
	return vec2(my_h, 0);
}


/*
5D wave noise
afl_ext 2018-2022
public domain
*/

float hash(float p){
    return fract(4768.1232345456 * sin(p));
}

float wave(vec4 uv, vec4 emitter, float speed, float phase, float timeshift){
    float dst = distance(uv, emitter);
    return exp(sin(dst * phase - timeshift * speed) - 1.0);
}
vec4 wavedrag(vec4 uv, vec4 emitter){
    return normalize(uv - emitter);
}
float seedWaves = 0.0;
vec4 randWaves(){
    float x = hash(seedWaves);
    seedWaves += 1.0;
    float y = hash(seedWaves);
    seedWaves += 1.0;
    float z = hash(seedWaves);
    seedWaves += 1.0;
    float w = hash(seedWaves);
    seedWaves += 1.0;
    return vec4(x,y,z,w) * 2.0 - 1.0;
}

float getwaves5d(vec4 position, float dragmult, float timeshift){
    float iter = 0.0;
    float phase = 6.0;
    float speed = 2.0;
    float weight = 1.0;
    float w = 0.0;
    float ws = 0.0;
    for(int i=0;i<20;i++){
        vec4 p = randWaves() * 30.0;
        float res = wave(position, p, speed, phase, 0.0 + timeshift);
        float res2 = wave(position, p, speed, phase, 0.006 + timeshift);
        position -= wavedrag(position, p) * (res - res2) * weight * dragmult;
        w += res * weight;
        iter += 12.0;
        ws += weight;
        weight = mix(weight, 0.0, 0.2);
        phase *= 1.2;
        speed *= 1.02;
    }
    return w / ws;
}

// helper function

vec3 polarToXyz(vec2 xy){
    xy *= vec2(2.0 *3.1415,  3.1415);
    float z = cos(xy.y);
    float x = cos(xy.x)*sin(xy.y);
    float y= sin(xy.x)*sin(xy.y);
    return normalize(vec3(x,y,z));
}

//float wave_h(float my_x, float my_y, float my_t) {
//	float water_h = getwaves5d(vec4(my_x*0.15, my_y*0.15, 0, 0.0), 15.0, my_t) * storm;
//	return water_h;
//}

float saw(float arg) {
	return abs(fract(arg/40) - .5)*40;
}

void main() {

	if (show == true) {

		float age;
		float phi = atan(p3d_Vertex.x, p3d_Vertex.y);
		float start_r = length(p3d_Vertex.xy);

		float birthday = 14.1421356237 - start_r;
		if (pt > birthday) {
			age = min((pt - birthday) * 1, 1);
			age = smoothstep(0, 1, age);
		} else {
			age = 0;
		}

		float r = start_r;

		vec4 cred_probe = vec4(0);
		if (head > 0) {
			if (r > 6 && r < 8) {
				cred_probe = texture(credits_tex, vec2(phi/(2.0*PI)+cred_shift, -(r-6)*0.2*0.5*0.98-0.2*line));
			}
		}

		vec4 new;

		new.x = r * cos(phi);
		new.y = r * sin(phi);
		new.z = getwaves5d(vec4(new.x*0.15, new.y*0.15, 0, 0.0), 15.0, osg_FrameTime) * storm;
		new.w = p3d_Vertex.w;

		seedWaves = 0.0;

		float diff = getwaves5d(vec4((new.x+0.02*20)*0.15, (new.y+0.02*20)*0.15, 0, 0.0), 15.0, osg_FrameTime) * storm;

		float diff_len = (diff - new.z)*5+0.5;
		float diff_moon = abs(diff - new.z)*100;

		new.z *= 5;

		gl_Position = p3d_ModelViewProjectionMatrix * new;

		color = vec4(vec3(55.0/255.0/2.0, 88.0/255.0/2.0, 114.0/255.0/2.0)*diff_len*color_magn, 1.0);
		float shine = smoothstep(1, -1, abs(gl_Position.x));

		color.rgb *= dark;
		color = mix(color, vec4(214.0/255.0, 95.0/255.0, 89.0/255.0, 1), diff_moon * shine * moon);

		color.rgb = mix(color.rgb, cred_probe.rgb, cred_probe.a * head);

		color = mix(color, vec4(102.0/255.0, 142.0/255.0, 167.0/255.0, 1.0), smoothstep(1.1, 1.5, new.z));

		if (reflection == true) {

			if (new.x > -4 && new.x < 4 && new.y > -4-window_z && new.y < 4-window_z) {

				//		vec2 tex_vertex = vec2((-new.x-8)/8, (-new.y-window_z)/8);
				vec2 tex_vertex = vec2(-new.x/8, (-new.y-window_z)/8);

				vec4 win_probe = texture(window_tex, tex_vertex+vec2(0.5));
				if (win_probe.a < 0.5) {

					vec4 probe;
					if (demo == 0) {
						probe = texture(enigma_tex, vec2(0.5-tex_vertex.x, (tex_vertex.y+0.5+int(-osg_FrameTime*25))/8));
					} else if (demo == 1) {
						vec2 coord;
						float pos_z = tex_vertex.y - sin(mod(osg_FrameTime * 2, PI))/2+0.25;
						vec2 desert_size = textureSize(desert_tex, 0);

						float factor_y = sin(osg_FrameTime*8) * 0.25 + 0.75;
						coord.y = pos_z * 2 * factor_y + 0.5;

						float factor_x = sin(osg_FrameTime*8+PI);
						float bend = 1+cos((coord.y-0.5)*PI)/2*factor_x;
						coord.x = -tex_vertex.x * 2 * desert_size.y / desert_size.x * bend + 0.5;

						if (coord.x < 0 || coord.x > 1 || coord.y < 0 || coord.y > 1) {
							probe = vec4(vec3(0), 0);
						} else {
							probe = texture(desert_tex, coord);
						}

						//				probe.rgb = vec3(tex_vertex.x, tex_vertex.y, 0);
					} else if (demo == 2) {
						int frame = int(abs(mod(osg_FrameTime*50, 128) - 64));
						probe = texture(state_tex, vec2(0.5-tex_vertex.x, (tex_vertex.y+0.5+frame)/64));
					} else if (demo == 3) {
						//			vec2 uv = vec2(p3d_Vertex.x, p3d_Vertex.z);
						vec2 uv = vec2(tex_vertex.x, tex_vertex.y);
						float zoom = sin(osg_FrameTime * 0.8 / 2.0) * 2.0 + 2.5;
						float u = (uv.x - sin(osg_FrameTime * 1.1 / 2.0)) * zoom;
						float v = (uv.y - cos(osg_FrameTime * 0.9 / 2.0)) * zoom;
						float theta = osg_FrameTime * 1.2 / 2.0;
						vec2 coord = vec2(
						u * cos(theta) - v * sin(theta) + 0.5,
						u * sin(theta) + v * cos(theta) + 0.5
						);
						probe = texture(second_tex, coord);
					} else if (demo == 4) {
						time=iTime+1.0;
						bob=cos(time*12.0)*0.05;
						scroll=-15.0+mod(time*wc_scale, wlen)*2.0;
						//	vec2 uv = fragCoord.xy / iResolution.xy;
						//		vec2 uv = fragCoord.xy / iResolution.xy;
						vec2 uv = vec2(tex_vertex.x + 0.5, tex_vertex.y + 0.5);

						vec2 q=uv;
						vec2 t=uv*2.0-vec2(1.0);
						//	t.x*=iResolution.x/iResolution.y;
						//		t.x*=1.25;
						probe.rgb = scene(t.xy) * 1.3;

						// vignet
						probe.rgb *= 0.5 + 0.5*pow(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y), 0.1);

						//				probe.rgb = vec3(tex_vertex.x, tex_vertex.y, 0);
					} else if (demo == 5) {
						probe = texture(megademo_tex, vec2(0.5-tex_vertex.x, (tex_vertex.y+0.5+int(-osg_FrameTime*50))/24));
						//				probe.rgb = vec3(tex_vertex.x, tex_vertex.y, 0);
					} else if (demo == 6) {
						int frame = int(abs(mod(osg_FrameTime*60, 88) - 44));
						probe = texture(lifeforce_tex, vec2(0.5-tex_vertex.x, (tex_vertex.y+0.5+frame)/44));
					} else if (demo == 7) {
						probe = texture(ziphead_tex, vec2(0.5-tex_vertex.x, (tex_vertex.y+0.5+int(-osg_FrameTime*60))/45));
					}

					//		color = mix(color, probe, 0.5);
					color = color + probe/2;

				}
			}
		}

		//	color = vec4(vec3(new.z), 1);
		//	color.a = 0.05;

		color.a = 1.0 - sqrt(pow(p3d_Vertex.x, 2) + pow(p3d_Vertex.y, 2)) / max_r;

		if (gray > 0) {
			float lum = dot(vec3(0.299, 0.587, 0.114), color.rgb);
			color.rgb = mix(color.rgb, vec3(lum), gray);
		}

		if (fade != 1) {
			color.rgb *= fade;
		}

		gl_PointSize = size / length((p3d_ModelViewMatrix * p3d_Vertex).xyz);
	} else {
		color.a = 0;
	}
}
