#version 410
#define HALF_PI radians(90)
//#define DIST 1.6
//#define DIST 3.9
#define DIST 3.9

// Uniform inputs
uniform mat4 p3d_ModelViewProjectionMatrix;
uniform	float t;  // time
uniform	float s;  // time
uniform float range;
uniform float s_freq;
uniform float s_amp;
uniform float t_freq_xz;
uniform float t_freq_t;
uniform float t_amp;
uniform float neon;
uniform float seed;
//uniform float neon_strength;
//uniform float dist;
uniform mat4 p3d_ModelViewMatrix;
uniform float size;
uniform float mono;
uniform bool emerging;

// Reports the frame time of the current frame, for animations.
uniform float osg_FrameTime;

// Vertex inputs
in vec4 p3d_Vertex;
in vec4 p3d_Color;
in vec2 p3d_MultiTexCoord0;

// Output to fragment shader
//out vec2 texcoord;
out vec4 color;

// Notes
// http://www.science-and-fiction.org/rendering/noise.html
// https://shadertoyunofficial.wordpress.com/2019/01/02/programming-tricks-in-shadertoy-glsl/
// https://en.wikipedia.org/wiki/Perlin_noise
// https://en.wikipedia.org/wiki/Simplex_noise
// https://www.shadertoy.com/view/XsX3zB

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Old noise function
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/* discontinuous pseudorandom uniformly distributed in [-0.5, +0.5]^3 */
vec3 random3(vec3 c) {
	float j = 4096.0*sin(dot(c,vec3(17.0, 59.4, 15.0)));
	vec3 r;
	r.z = fract(512.0*j);
	j *= .125;
	r.x = fract(512.0*j);
	j *= .125;
	r.y = fract(512.0*j);
	return r-0.5;
}

/* skew constants for 3d simplex functions */
const float F3 =  0.3333333;
const float G3 =  0.1666667;

/* 3d simplex noise */
float simplex3d(vec3 p) {
	 /* 1. find current tetrahedron T and it's four vertices */
	 /* s, s+i1, s+i2, s+1.0 - absolute skewed (integer) coordinates of T vertices */
	 /* x, x1, x2, x3 - unskewed coordinates of p relative to each of T vertices*/

	 /* calculate s and x */
	 vec3 s = floor(p + dot(p, vec3(F3)));
	 vec3 x = p - s + dot(s, vec3(G3));

	 /* calculate i1 and i2 */
	 vec3 e = step(vec3(0.0), x - x.yzx);
	 vec3 i1 = e*(1.0 - e.zxy);
	 vec3 i2 = 1.0 - e.zxy*(1.0 - e);

	 /* x1, x2, x3 */
	 vec3 x1 = x - i1 + G3;
	 vec3 x2 = x - i2 + 2.0*G3;
	 vec3 x3 = x - 1.0 + 3.0*G3;

	 /* 2. find four surflets and store them in d */
	 vec4 w, d;

	 /* calculate surflet weights */
	 w.x = dot(x, x);
	 w.y = dot(x1, x1);
	 w.z = dot(x2, x2);
	 w.w = dot(x3, x3);

	 /* w fades from 0.6 at the center of the surflet to 0.0 at the margin */
	 w = max(0.6 - w, 0.0);

	 /* calculate surflet components */
	 d.x = dot(random3(s), x);
	 d.y = dot(random3(s + i1), x1);
	 d.z = dot(random3(s + i2), x2);
	 d.w = dot(random3(s + 1.0), x3);

	 /* multiply d by w^4 */
	 w *= w;
	 w *= w;
	 d *= w;

	 /* 3. return the sum of the four surflets */
	 return dot(d, vec4(52.0));
}
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

/* const matrices for 3d rotation */
const mat3 rot1 = mat3(-0.37, 0.36, 0.85,-0.14,-0.93, 0.34,0.92, 0.01,0.4);
const mat3 rot2 = mat3(-0.55,-0.39, 0.74, 0.33,-0.91,-0.24,0.77, 0.12,0.63);
const mat3 rot3 = mat3(-0.71, 0.52,-0.47,-0.08,-0.72,-0.68,-0.7,-0.45,0.56);

void main() {
	float tile_scale = 1;
	float simplex_scale = 0.1;
	float distance = 134;  // 77

	color = p3d_Color;
	vec4 new = p3d_Vertex;

	if (emerging == true) {

		if (p3d_Vertex.z < -DIST) {
			vec2 floor_id = vec2(round(p3d_Vertex.x * tile_scale) / tile_scale, round(p3d_Vertex.y * tile_scale) / tile_scale);
			float floor_delay = simplex3d(vec3(floor_id.x * simplex_scale, floor_id.y * simplex_scale, seed));
			new.z -= smoothstep(1, -1, t + floor_delay) * distance;
		}

		if (p3d_Vertex.z > DIST) {
			vec2 ceil_id = vec2(round(p3d_Vertex.x * tile_scale) / tile_scale, round(p3d_Vertex.y * tile_scale) / tile_scale);
			float ceil_delay = simplex3d(vec3(ceil_id.x * simplex_scale, seed, ceil_id.y * simplex_scale));
			new.z += smoothstep(1, -1, t + ceil_delay) * distance;
		}

		if (p3d_Vertex.z >= -DIST && p3d_Vertex.z <= DIST) {
			float mag = smoothstep(DIST, 0.0, -DIST + s*2 + abs(p3d_Vertex.z));
			float alpha = smoothstep(0.0, DIST, -DIST + s*2 + abs(p3d_Vertex.z));
			new.x += simplex3d(vec3(new.z, new.y, s)) * mag;
			new.y += simplex3d(vec3(s, new.z, new.y)) * mag;
			color.a = alpha;
		}

	}

//	color.rgb = mix(color.rgb, color.rgb * neon * 10, 1 / length(vec2(p3d_Vertex.x+7.4,p3d_Vertex.z-1.9)));
	color.rgb = mix(color.rgb, color.rgb * neon, 1 / length(vec2(p3d_Vertex.x,p3d_Vertex.z-1.9)));

//	Mono palette
//	float mono = 0.75;
	float lum = dot(vec3(0.299, 0.587, 0.114), color.rgb);
	color.rgb = mix(color.rgb, vec3(199.0/255.0, 191.0/255.0, 186.0/255.0) * lum, mono);

//	color *= 5;

	gl_Position = p3d_ModelViewProjectionMatrix * new;
	gl_PointSize = size / length((p3d_ModelViewMatrix * new).xyz);
}
